define('bitbucket/internal/feature/commit/commit-deployments/commit-deployments-list', ['module', 'exports', 'jquery', 'bitbucket/internal/widget/paged-scrollable', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state'], function (module, exports, _jquery, _pagedScrollable, _navbuilder, _server, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _pagedScrollable2 = _interopRequireDefault(_pagedScrollable);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    var _get = function get(object, property, receiver) {
        if (object === null) object = Function.prototype;
        var desc = Object.getOwnPropertyDescriptor(object, property);

        if (desc === undefined) {
            var parent = Object.getPrototypeOf(object);

            if (parent === null) {
                return undefined;
            } else {
                return get(parent, property, receiver);
            }
        } else if ("value" in desc) {
            return desc.value;
        } else {
            var getter = desc.get;

            if (getter === undefined) {
                return undefined;
            }

            return getter.call(receiver);
        }
    };

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var CommitDeploymentsList = function (_PagedScrollable) {
        _inherits(CommitDeploymentsList, _PagedScrollable);

        function CommitDeploymentsList() {
            _classCallCheck(this, CommitDeploymentsList);

            return _possibleConstructorReturn(this, (CommitDeploymentsList.__proto__ || Object.getPrototypeOf(CommitDeploymentsList)).apply(this, arguments));
        }

        _createClass(CommitDeploymentsList, [{
            key: 'attachNewContent',
            value: function attachNewContent(data, attachmentMethod) {
                this.$scrollElement.find('table')[attachmentMethod](data.values.map(function (deployment) {
                    return bitbucket.internal.feature.commit.commitDeployments.commitDeployments.deploymentRow({
                        deployment: deployment
                    });
                }));
            }
        }, {
            key: 'requestData',
            value: function requestData(start, limit) {
                var repository = _state2.default.getRepository();
                var commit = _state2.default.getCommit();
                var $deployments = (0, _jquery2.default)('#deployments-list');
                var $spinner = (0, _jquery2.default)('<div class="deployments-spinner"><aui-spinner size="medium"></aui-spinner><div>');

                $spinner.appendTo($deployments);

                return (0, _server.rest)({
                    url: nav.rest('ui').repository(repository).commit(commit.id).addPathComponents('deployments').withParams({ start: start, limit: limit }).build()
                }).always(function () {
                    $spinner.remove();
                });
            }
        }, {
            key: 'handleErrors',
            value: function handleErrors(errors) {}
        }, {
            key: 'reset',
            value: function reset() {
                this.$scrollElement.find('ul').empty();
                _get(CommitDeploymentsList.prototype.__proto__ || Object.getPrototypeOf(CommitDeploymentsList.prototype), 'reset', this).call(this);
            }
        }]);

        return CommitDeploymentsList;
    }(_pagedScrollable2.default);

    exports.default = CommitDeploymentsList;
    module.exports = exports['default'];
});