define('bitbucket/internal/feature/commit/commit-deployments/commit-deployments', ['module', 'exports', 'jquery', 'bitbucket/internal/util/analytics', 'bitbucket/util/state', './commit-deployments-list'], function (module, exports, _jquery, _analytics, _state, _commitDeploymentsList) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var analytics = _interopRequireWildcard(_analytics);

    var _state2 = _interopRequireDefault(_state);

    var _commitDeploymentsList2 = _interopRequireDefault(_commitDeploymentsList);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function onReady() {
        var commitDeploymentsList = new _commitDeploymentsList2.default('#deployments-list');
        (0, _jquery2.default)(document).on('aui-show', '#list-deployments-inline-dialog', function () {
            commitDeploymentsList.init();

            analytics.add('commit.deployment.dialog.opened', {
                'repository.id': _state2.default.getRepository().id
            });
        }).on('mousedown', 'a.deployment-url', function () {
            analytics.add('commit.deployment.url.clicked', {
                'repository.id': _state2.default.getRepository().id
            });
        }).on('aui-hide', '#list-deployments-inline-dialog', function () {
            return commitDeploymentsList.reset();
        });
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});