define('bitbucket/internal/feature/commit/difftree/difftree-search-input', ['module', 'exports', '@atlassian/aui', 'baconjs', 'jquery', 'lodash', 'bitbucket/internal/util/events', 'bitbucket/internal/util/function'], function (module, exports, _aui, _baconjs, _jquery, _lodash, _events, _function) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _baconjs2 = _interopRequireDefault(_baconjs);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _events2 = _interopRequireDefault(_events);

    var _function2 = _interopRequireDefault(_function);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    _baconjs2.default; // TODO: Remove this once we have an annotation for checkstyle to ignore a file or specific dependencies
    function SearchInput(opts) {
        this.$el = (0, _jquery2.default)(bitbucket.internal.feature.commit.difftree.difftreeSearchInput.searchInput(opts));

        this._destroyables = [];

        var $input = this.$el.find('input');
        var $deleteButton = this.$el.find('.delete-button');
        this._destroyables.push(_events2.default.chainWith($deleteButton).on('click', function (e) {
            e.preventDefault();
            $input.val('').trigger('input');
        }));
        this._destroyables.push(_events2.default.chainWith($input).on('input', function (e) {
            $deleteButton.toggle(!!this.value);
        }));
    }

    /**
     * @returns {Bacon<string>} a stream of text inputs, where blank indicates the user wants to clear the search
     */
    SearchInput.prototype.getInputs = function () {
        var clearEvents = this.$el.find('.delete-button').asEventStream('click');
        var keyup = this.$el.find('input').asEventStream('keyup');
        var keyCodeEq = _function2.default.dotEq.bind(null, 'keyCode');
        var escapeStream = keyup.filter(keyCodeEq(AJS.keyCode.ESCAPE));

        var isEnterKey = keyCodeEq(AJS.keyCode.ENTER);

        return keyup.filter(isEnterKey).merge(escapeStream).doAction('.preventDefault').doAction('.currentTarget.blur').filter(isEnterKey).flatMap(function (e) {
            return e.target.value;
        }).merge(clearEvents.map(_function2.default.constant(''))).skipDuplicates();
    };

    SearchInput.prototype.destroy = function () {
        _lodash2.default.invokeMap(this._destroyables, 'destroy');
    };

    exports.default = SearchInput;
    module.exports = exports['default'];
});