define('bitbucket/internal/feature/commit/request-commit', ['module', 'exports', 'lodash', 'bitbucket/internal/util/ajax', 'bitbucket/util/navbuilder', 'bitbucket/util/state'], function (module, exports, _lodash, _ajax, _navbuilder, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.default = requestCommit;

    var ajax = _interopRequireWildcard(_ajax);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var cache = {};

    /**
     * Return a promise containing the commit JSON object
     */
    function requestCommit(_ref) {
        var commitId = _ref.commitId,
            project = _ref.project,
            repo = _ref.repo,
            _ref$statusCode = _ref.statusCode,
            statusCode = _ref$statusCode === undefined ? {} : _ref$statusCode;

        if (cache.hasOwnProperty(commitId)) {
            return cache[commitId];
        }

        var url = void 0;

        if (project && repo) {
            url = nav.rest().project(project).repo(repo).commit(commitId).build();
        } else if (_state2.default.getRepository()) {
            //fallback to using the currentRepo
            url = nav.rest().repository(_state2.default.getRepository()).commit(commitId).build();
        } else {
            return Promise.reject(new Error('Repository required'));
        }

        cache[commitId] = new Promise(function (resolve, reject) {
            ajax.rest({
                url: url,
                statusCode: _extends({}, ajax.ignore404WithinRepository(), statusCode)
            }).done(resolve).fail(function (xhr, textStatus, errorThrown, data) {
                delete cache[commitId];
                reject((0, _lodash.get)(data, 'errors.length') ? new Error(data.errors[0].message) : new Error('Commit request failed'));
            });
        });

        return cache[commitId];
    }
    module.exports = exports['default'];
});