define('bitbucket/internal/feature/enforce-project-settings/enforce-project-settings', ['exports', 'jquery', 'bitbucket/internal/enums', 'bitbucket/internal/util/enforce-project-settings/util'], function (exports, _jquery, _enums, _util) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.bindEnforceSettingsSelector = bindEnforceSettingsSelector;
    exports.getEnforceSettingsSelectorValue = getEnforceSettingsSelectorValue;
    exports.isUnsavedSettingEnforced = isUnsavedSettingEnforced;
    exports.setEnforceProjectSettingsState = setEnforceProjectSettingsState;
    exports.initiatePollTimer = initiatePollTimer;

    var _jquery2 = _interopRequireDefault(_jquery);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    // dropdown
    var enforceSettingsSelector = '.settings-selector-items';
    // each item in the dropdown
    var enforceSettingsItem = '.settings-selector-item';
    // selected item
    var enforceSettingsTrigger = '.enforce-settings-trigger';
    var inputEl = 'input[name="branch-model-eps"]';

    var RESTRICTION_POLLING_INTERVAL_MILLISECONDS = 2000;

    var state = {
        isSettingEnforced: 'false'
    };

    var setState = function setState(newState) {
        state = _extends({}, state, newState);

        return state;
    };

    /**
     * Update the trigger value with the selected dropdown item
     *
     * @param {Event} e
     */
    function bindEnforceSettingsSelector($container) {
        var $enforceSettingsSelector = $container ? $container.find(enforceSettingsSelector) : (0, _jquery2.default)(enforceSettingsSelector);

        var $inputEl = $container ? $container.find(inputEl) : (0, _jquery2.default)(inputEl);
        setState({
            isSettingEnforced: $inputEl.val()
        });

        $enforceSettingsSelector.on('click', 'a', function (e) {
            e.preventDefault();
            var $enforceSettingsTrigger = $container ? $container.find(enforceSettingsTrigger) : (0, _jquery2.default)(enforceSettingsTrigger);

            var $dropdownItem = (0, _jquery2.default)(e.currentTarget).children('p').clone();
            $enforceSettingsTrigger.find(enforceSettingsItem).replaceWith($dropdownItem);
            $inputEl.val($dropdownItem.data('value') === _enums.ProjectRestrictionOptions.LOCKED);
        });
    }

    /**
     * Get the restriction dropdown value
     * @param {*} $container jQuery object in which the element is being rendered
     * @returns oneOf(ProjectRestrictionOptions)
     */
    function getEnforceSettingsSelectorValue($container) {
        var $enforceSettingsTrigger = $container ? $container.find(enforceSettingsTrigger) : (0, _jquery2.default)(enforceSettingsTrigger);

        return $enforceSettingsTrigger.children(enforceSettingsItem).data('value');
    }

    /**
     * Check if restriction is added but not saved yet
     * Used to show warning modals
     * @param {*} $container jQuery object in which the element is being rendered
     * @returns Boolean
     */
    function isUnsavedSettingEnforced($container) {
        var currentValue = getEnforceSettingsSelectorValue($container);

        return currentValue === _enums.ProjectRestrictionOptions.LOCKED && state.isSettingEnforced !== (0, _jquery2.default)(inputEl).val();
    }

    /**
     * Update dropdown selector state on save
     */
    function setEnforceProjectSettingsState(restrictionState, options) {
        if ((0, _util.isRestrictionProcessing)(restrictionState)) {
            initiatePollTimer(options);
            // show spinner
            (0, _jquery2.default)(enforceSettingsTrigger).html(bitbucket.internal.feature.enforceProjectSettings.spinner());
        }

        setState({
            isSettingEnforced: (0, _jquery2.default)(inputEl).val()
        });
    }

    /**
     * Initiate poll timer and check processed state
     * If PROCESSED update the selector
     * @param {Object} options consists of project, featureKey & (optional) componentKey
     */
    function initiatePollTimer(options) {
        // Then on every specified interval
        var pollTimer = setInterval(function () {
            (0, _util.fetchRestriction)(options).then(function (response) {
                if ((0, _util.isProjectSettingRestricted)(response.processedState)) {
                    // update the selector
                    var $enforceSettingsTrigger = (0, _jquery2.default)(enforceSettingsTrigger);
                    // find the locked dropdown item and append to trigger - so that it appears as selected value
                    var $lockedDropdownItem = (0, _jquery2.default)(enforceSettingsItem + '[data-value="' + _enums.ProjectRestrictionOptions.LOCKED + '"]').clone();

                    $enforceSettingsTrigger.find(enforceSettingsItem).replaceWith($lockedDropdownItem);
                    $enforceSettingsTrigger.prop('disabled', false);
                    clearInterval(pollTimer);
                }
            }).catch(function () {
                // stop polling on error.
                clearInterval(pollTimer);
            });
        }, RESTRICTION_POLLING_INTERVAL_MILLISECONDS);
    }
});