define('bitbucket/internal/feature/file-content/request-source', ['module', 'exports', 'jquery', 'lodash', 'bitbucket/internal/util/ajax', 'bitbucket/internal/util/property', 'bitbucket/util/navbuilder', 'bitbucket/util/state'], function (module, exports, _jquery, _lodash, _ajax, _property, _navbuilder, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var ajax = _interopRequireWildcard(_ajax);

    var _property2 = _interopRequireDefault(_property);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var maxSourceLines = _property2.default.getFromProviderSync('page.max.source.lines');

    // See notes on requestSource. We cache to avoid multiple server requests for the same information by different handlers,
    // and also so source=handler and source-view can both request the first page without a full AJAX request twice.
    var cache = {};

    /**
     * A builder to generate the source URL.
     *
     * @param {JSON.FileChangeJSON} fileChangeJSON a fileChange object describing the change
     * @param {Object} [options] - additional options
     * @param {number} [options.start]
     * @param {number} [options.limit]
     * @param {boolean} [options.includeBlame]
     * @param {boolean} [options.getSize]
     * @returns {string} a source URL
     * @private
     */
    function getSourceUrl(fileChangeJSON, options) {
        //$.extend to remove undefined properties
        var params = _jquery2.default.extend({}, {
            start: options.start || 0,
            limit: options.limit || maxSourceLines,
            blame: options.includeBlame ? true : undefined,
            size: options.getSize ? true : undefined
        });

        return nav.rest().repository(_state2.default.getRepository()).browse().path(fileChangeJSON.path).at(fileChangeJSON.commitRange.untilRevision.id).withParams(params).build();
    }

    /**
     * Request diff information from the server. Requests are cached for the remainder of an event loop after they are resolved.
     * This helps with performance of multiple handlers requesting the same data.
     *
     * @param {JSON.FileChangeJSON} fileChange - a fileChange object describing the change
     * @param {Object} [options] - additional options
     * @param {number} [options.start]
     * @param {number} [options.limit]
     * @param {boolean} [options.includeBlame]
     * @param {Object} [options.statusCode]
     * @param {Boolean} [options.getSize]
     * @returns {Promise} a promise that resolves to the diff JSON returned form the server.
     */
    function requestSource(fileChange, options) {
        options = options || {};

        var fileChangeJSON = fileChange.toJSON ? fileChange.toJSON() : fileChange;
        var url = getSourceUrl(fileChangeJSON, options);

        if (cache.hasOwnProperty(url) && cache[url].state() !== 'rejected') {
            return cache[url];
        }

        var xhr = ajax.rest({
            url: url,
            statusCode: options.statusCode || ajax.ignore404WithinRepository()
        });

        var piped = xhr.then(function (data) {
            if (data.errors && data.errors.length) {
                return _jquery2.default.Deferred().rejectWith(this, [this, null, null, data]);
            }

            _lodash2.default.defer(function () {
                delete cache[url];
            });

            return data;
        });

        cache[url] = piped.promise(xhr);

        return cache[url];
    }

    exports.default = requestSource;
    module.exports = exports['default'];
});