define('bitbucket/internal/feature/filebrowser/file-table-history/file-table-history', ['module', 'exports', 'jquery', 'lodash', 'bitbucket/internal/model/page-state', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/string-replacer', 'bitbucket/util/events', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state'], function (module, exports, _jquery, _lodash, _pageState, _analytics, _stringReplacer, _events, _navbuilder, _server, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _pageState2 = _interopRequireDefault(_pageState);

    var analytics = _interopRequireWildcard(_analytics);

    var _stringReplacer2 = _interopRequireDefault(_stringReplacer);

    var _events2 = _interopRequireDefault(_events);

    var nav = _interopRequireWildcard(_navbuilder);

    var server = _interopRequireWildcard(_server);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var lastHistoryRequest;
    var lastRequestStart;

    var commitMessageEnrichment = new _stringReplacer2.default();

    function abortLastRequest() {
        if (lastHistoryRequest) {
            lastHistoryRequest.abort();
        }
    }

    function _createCommitLink(shortMessage, commit, fileUrl) {
        // Don't link leading/trailing whitespace
        return bitbucket.internal.feature.filebrowser.fileTableHistory.fileTableHistory.link({
            commit: commit,
            fileUrl: fileUrl,
            shortMessage: shortMessage.trim(),
            leadingSpaces: shortMessage.match(/^\s*/)[0],
            trailingSpaces: shortMessage.match(/\s*$/)[0]
        });
    }

    function updateHistory() {
        abortLastRequest();

        var ref = _pageState2.default.getRevisionRef();
        var commitId = ref.isCommit() ? ref.getId() : ref.getLatestCommit();
        var pathComponents = _pageState2.default.getFilePath().getComponents();

        lastHistoryRequest = server.rest({
            url: nav.rest().repository(_state2.default.getRepository()).lastModified().path(pathComponents).at(commitId).build(),
            statusCode: {
                404: false,
                500: false,
                0: function _(xhr, statusText) {
                    if (statusText === 'timeout') {
                        analytics.add('filetable.lastmodified.timeout');

                        return false;
                    }

                    if (statusText === 'abort') {
                        analytics.add('filetable.lastmodified.aborted', {
                            requestTime: Date.now() - lastRequestStart
                        });

                        return false;
                    }
                }
            }
        }).done(function (history) {
            analytics.add('filetable.lastmodified.succeeded', {
                //Only care about the request time, not the render time (below)
                requestTime: Date.now() - lastRequestStart
            });

            //If there is no file history, bail out early
            if (!Object.keys(history.files).length) {
                return;
            }

            var $fileBrowserTable = (0, _jquery2.default)('.filebrowser-table');

            //Change the history column header cells from display:none to opacity:0 in preparation for animating them in
            $fileBrowserTable.find('th.hidden').removeClass('hidden').addClass('hide');

            // only display latest commit message on files, not directories
            $fileBrowserTable.find('tr.file').each(function () {
                var $fileRow = (0, _jquery2.default)(this);
                var fileName = $fileRow.data('item-name');
                var commit = history.files[fileName];

                if (!commit) {
                    return;
                }
                var fileUrl = nav.repository(_state2.default.getRepository()).commit(commit.id).withFragment(pathComponents.concat(fileName).join('/')).build();

                // commit.message only contains the 'subject' part of the commit message (ie nothing after the first
                // '\n\n') - so no need to split it into subject and body here
                commitMessageEnrichment.process(commit.message, commit, function (commitMsgSubstr) {
                    return _createCommitLink(commitMsgSubstr, commit, fileUrl);
                }).then(function (replacements) {
                    $fileRow.find('.file-size').before(bitbucket.internal.feature.filebrowser.fileTableHistory.fileTableHistory.message({
                        linkHtml: replacements
                    })).after(bitbucket.internal.feature.filebrowser.fileTableHistory.fileTableHistory.timestamp({
                        commit: commit
                    }));

                    $fileRow.find('.item-name').removeAttr('colspan');
                });
            });
            _lodash2.default.defer(function () {
                // this is sad, but it turns out you cannot add and animate an element in the same JS round
                // using a timeout to trigger the proper animation :(
                $fileBrowserTable.find('th.hide, td.hide').removeClass('hide');
            });
        }).always(function () {
            lastHistoryRequest = null;
            lastRequestStart = null;
        });
        lastRequestStart = Date.now();
    }

    function init() {
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.filebrowser.filesChanged', updateHistory);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.filefinder.unloaded', updateHistory);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.filefinder.loaded', abortLastRequest);
    }

    exports.default = {
        init: init,
        commitMessageEnrichment: commitMessageEnrichment
    };
    module.exports = exports['default'];
});