define('bitbucket/internal/feature/integrity/alert', ['exports', '@atlassian/aui', 'bitbucket/internal/feature/alerts/alerts', 'bitbucket/internal/util/ajax', 'bitbucket/util/navbuilder'], function (exports, _aui, _alerts, _ajax, _navbuilder) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.init = init;

    var AJS = _interopRequireWildcard(_aui);

    var ajax = _interopRequireWildcard(_ajax);

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var MessageType = {
        INFO: 'info',
        WARN: 'warning'
    };
    var State = {
        STARTED: {
            closeable: false,
            title: AJS.I18n.getText('bitbucket.web.admin.integrity.check.started.banner.title'),
            description: AJS.I18n.getText('bitbucket.web.admin.integrity.check.started.banner.text')
        },
        INCONSISTENT: {
            closeable: false,
            title: AJS.I18n.getText('bitbucket.web.admin.integrity.check.inconsistent.banner.title'),
            description: AJS.I18n.getText('bitbucket.web.admin.integrity.check.inconsistent.banner.text')
        },
        COMPLETED: {
            closeable: true,
            title: AJS.I18n.getText('bitbucket.web.admin.integrity.check.completed.banner.title'),
            description: AJS.I18n.getText('bitbucket.web.admin.integrity.check.completed.banner.text')
        },
        INCONSISTENT_COMPLETED: {
            closeable: true,
            title: AJS.I18n.getText('bitbucket.web.admin.integrity.check.inconsistent.completed.banner.title'),
            description: AJS.I18n.getText('bitbucket.web.admin.integrity.check.inconsistent.completed.banner.text')
        }
    };

    function init(states) {
        if (!states || states.length === 0) {
            return;
        }
        var _state = void 0;
        var messageType = void 0;

        switch (states[0]) {
            case 'acknowledged':
                // Bail out. The banner need not be shown.
                return;
            case 'started':
                messageType = MessageType.INFO;
                _state = State.STARTED;
                break;
            case 'inconsistency':
                if (states[1] === 'started') {
                    messageType = MessageType.WARN;
                    _state = State.INCONSISTENT;
                } else {
                    // Bail out. The banner need not be shown.
                    // This can happen when triggering checks via REST.
                    return;
                }
                break;
            case 'completed':
                // Done
                if (states[1] === 'inconsistency') {
                    messageType = MessageType.WARN;
                    _state = State.INCONSISTENT_COMPLETED;
                } else {
                    messageType = MessageType.INFO;
                    _state = State.COMPLETED;
                }
                break;
            default:
                console.warn('Could not identify integrity checks state.', states);

                return;
        }

        var alertObj = _extends({
            type: messageType,
            closeCallback: function closeCallback() {
                ajax.rest({
                    url: nav.newBuilder('admin').addPathComponents('integrity-check', 'acknowledge').build(),
                    type: 'POST'
                });
            }
        }, _state);

        (0, _alerts.add)(alertObj);

        return alertObj;
    }
});