define('bitbucket/internal/feature/jupyter-notebook-file-handler/jupyter-notebook-file-handler-init', ['exports', 'bitbucket/feature/files/file-handlers', 'bitbucket/internal/feature/file-content/file-content-modes', 'bitbucket/internal/util/require-amd-context'], function (exports, _fileHandlers, _fileContentModes, _requireAmdContext) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._RESOURCES_CONTEXT = exports._HANDLER_MODULE = exports._loadResourcesIfRequired = exports.init = exports.NOTEBOOK_EXTENSION = undefined;

    var _fileHandlers2 = _interopRequireDefault(_fileHandlers);

    var _fileContentModes2 = _interopRequireDefault(_fileContentModes);

    var _requireAmdContext2 = _interopRequireDefault(_requireAmdContext);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var NOTEBOOK_EXTENSION = exports.NOTEBOOK_EXTENSION = 'ipynb';

    var RESOURCES_CONTEXT = 'bitbucket.feature.jupyter-notebook.resources';
    var HANDLER_MODULE = 'bitbucket/internal/feature/jupyter-notebook-file-handler/jupyter-notebook-file-handler';

    var loadResourcesIfRequired = function loadResourcesIfRequired(fileHandlingContext) {
        if (!(fileHandlingContext.contentMode === _fileContentModes2.default.SOURCE && fileHandlingContext.fileChange.path.extension === NOTEBOOK_EXTENSION)) {
            return false;
        }

        return (0, _requireAmdContext2.default)(RESOURCES_CONTEXT, [HANDLER_MODULE]).then(function (_ref) {
            var handle = _ref.handle;
            return handle(fileHandlingContext);
        });
    };

    var init = exports.init = function init() {
        _fileHandlers2.default.register({
            weight: 150,
            builtIn: false,
            handle: loadResourcesIfRequired
        });
    };

    //Exported for testing
    exports._loadResourcesIfRequired = loadResourcesIfRequired;
    exports._HANDLER_MODULE = HANDLER_MODULE;
    exports._RESOURCES_CONTEXT = RESOURCES_CONTEXT;
});