define('bitbucket/internal/feature/jupyter-notebook-file-handler/jupyter-notebook-file-handler-init.test', ['bitbucket/feature/files/file-handlers', 'bitbucket/internal/feature/file-content/file-content-modes', 'bitbucket/internal/feature/jupyter-notebook-file-handler/jupyter-notebook-file-handler-init', 'bitbucket/internal/util/require-amd-context'], function (_fileHandlers, _fileContentModes, _jupyterNotebookFileHandlerInit, _requireAmdContext) {
    'use strict';

    var _fileHandlers2 = _interopRequireDefault(_fileHandlers);

    var _fileContentModes2 = _interopRequireDefault(_fileContentModes);

    var _requireAmdContext2 = _interopRequireDefault(_requireAmdContext);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    jest.mock('bitbucket/feature/files/file-handlers', function () {
        return {
            register: jest.fn()
        };
    });
    jest.mock('bitbucket/internal/util/require-amd-context');

    beforeEach(function () {
        _fileHandlers2.default.register.mockReset();
        _requireAmdContext2.default.mockReset();
    });

    describe(_jupyterNotebookFileHandlerInit.init, function () {
        it('registers the handler', function () {
            expect(_fileHandlers2.default.register).not.toBeCalled();

            (0, _jupyterNotebookFileHandlerInit.init)();

            expect(_fileHandlers2.default.register).toBeCalledWith({
                weight: 150,
                builtIn: false,
                handle: _jupyterNotebookFileHandlerInit._loadResourcesIfRequired
            });
        });
    });

    describe(_jupyterNotebookFileHandlerInit._loadResourcesIfRequired, function () {
        var textExtension = 'txt';

        it('loads the resources when rendering the source view of a jupyter notebook', function () {
            var handle = jest.fn();

            _requireAmdContext2.default.mockReturnValue(Promise.resolve({ handle: handle }));

            var contentMode = _fileContentModes2.default.SOURCE;
            var fileChange = {
                path: {
                    extension: _jupyterNotebookFileHandlerInit.NOTEBOOK_EXTENSION
                }
            };
            var fileHandlingContext = { contentMode: contentMode, fileChange: fileChange };

            expect(_requireAmdContext2.default).not.toBeCalled();
            expect(handle).not.toBeCalled();

            var rtn = (0, _jupyterNotebookFileHandlerInit._loadResourcesIfRequired)(fileHandlingContext);

            expect(rtn).not.toBe(false);

            rtn.then(function () {
                expect(_requireAmdContext2.default).toBeCalledWith(_jupyterNotebookFileHandlerInit._RESOURCES_CONTEXT, [_jupyterNotebookFileHandlerInit._HANDLER_MODULE]);
                expect(handle).toBeCalledWith(fileHandlingContext);
            });
        });

        it('does not load the resources when rendering the diff view of a jupyter notebook', function () {
            var handle = jest.fn();

            _requireAmdContext2.default.mockReturnValue(Promise.resolve({ handle: handle }));

            var contentMode = _fileContentModes2.default.DIFF;
            var fileChange = {
                path: {
                    extension: _jupyterNotebookFileHandlerInit.NOTEBOOK_EXTENSION
                }
            };
            var fileHandlingContext = { contentMode: contentMode, fileChange: fileChange };

            expect(_requireAmdContext2.default).not.toBeCalled();
            expect(handle).not.toBeCalled();

            var rtn = (0, _jupyterNotebookFileHandlerInit._loadResourcesIfRequired)(fileHandlingContext);

            expect(rtn).toBe(false);

            expect(_requireAmdContext2.default).not.toBeCalled();
            expect(handle).not.toBeCalled();
        });

        it('does not load the resources when rendering the source view of a non-notebook file', function () {
            var handle = jest.fn();

            _requireAmdContext2.default.mockReturnValue(Promise.resolve({ handle: handle }));

            var contentMode = _fileContentModes2.default.SOURCE;
            var fileChange = {
                path: {
                    extension: textExtension
                }
            };
            var fileHandlingContext = { contentMode: contentMode, fileChange: fileChange };

            expect(_requireAmdContext2.default).not.toBeCalled();
            expect(handle).not.toBeCalled();

            var rtn = (0, _jupyterNotebookFileHandlerInit._loadResourcesIfRequired)(fileHandlingContext);

            expect(rtn).toBe(false);

            expect(_requireAmdContext2.default).not.toBeCalled();
            expect(handle).not.toBeCalled();
        });

        it('does not load the resources when rendering the diff view of a non-notebook file', function () {
            var handle = jest.fn();

            _requireAmdContext2.default.mockReturnValue(Promise.resolve({ handle: handle }));

            var contentMode = _fileContentModes2.default.DIFF;
            var fileChange = {
                path: {
                    extension: textExtension
                }
            };
            var fileHandlingContext = { contentMode: contentMode, fileChange: fileChange };

            expect(_requireAmdContext2.default).not.toBeCalled();
            expect(handle).not.toBeCalled();

            var rtn = (0, _jupyterNotebookFileHandlerInit._loadResourcesIfRequired)(fileHandlingContext);

            expect(rtn).toBe(false);

            expect(_requireAmdContext2.default).not.toBeCalled();
            expect(handle).not.toBeCalled();
        });
    });
});