define('bitbucket/internal/feature/jupyter-notebook-file-handler/jupyter-notebook-file-handler', ['exports', 'dompurify', 'jquery', 'mathjax', 'notebookjs', 'wrm/i18n', 'bitbucket/internal/feature/file-content/request-source', 'bitbucket/internal/util/property', 'bitbucket/internal/util/syntax-highlight/syntax-highlight', 'bitbucket/util/events', 'bitbucket/util/navbuilder', 'bitbucket/util/server'], function (exports, _dompurify, _jquery, _mathjax, _notebookjs, _i18n, _requestSource, _property, _syntaxHighlight, _events, _navbuilder, _server) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._handlerDOMClass = exports._handlerId = exports.handle = undefined;

    var _dompurify2 = _interopRequireDefault(_dompurify);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _mathjax2 = _interopRequireDefault(_mathjax);

    var _notebookjs2 = _interopRequireDefault(_notebookjs);

    var _requestSource2 = _interopRequireDefault(_requestSource);

    var _property2 = _interopRequireDefault(_property);

    var _events2 = _interopRequireDefault(_events);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var handlerId = 'jupyter-notebook';
    var handlerDOMClass = handlerId;
    var MAX_NOTEBOOK_SIZE = _property2.default.getFromProviderSync('display.max.jupyter.notebook.size');
    var sanitizeForJquery = function sanitizeForJquery(html) {
        return _dompurify2.default.sanitize(html, { SAFE_FOR_JQUERY: true });
    };

    //The default sanitizer in NotebookJS doesn't set the SAFE_FOR_JQUERY flag
    _notebookjs2.default.sanitizer = sanitizeForJquery;

    var getRawFileUrl = function getRawFileUrl(fileChange) {
        return (0, _navbuilder.project)(fileChange.repository.project).repo(fileChange.repository).raw().path(fileChange.path).at(fileChange.commitRange.untilRevision.id).build();
    };

    var fetchRawNotebook = function fetchRawNotebook(fileChange) {
        return (0, _server.rest)({ url: getRawFileUrl(fileChange), accepts: '*/*', dataType: 'text' });
    };

    var renderNotebook = function renderNotebook(notebook, $container) {
        var notebookHtml = notebook.render().outerHTML;
        //Technically we are double sanitizing at this point, but the internal sanitization in NotebookJS only applies to html output segments
        //I figure better safe than sorry and run a sanitize on the full output also
        var cleanHtml = sanitizeForJquery(notebookHtml);

        $container.html(cleanHtml).find('.nb-notebook').addClass('markup').find('table').removeAttr('border'); //remove any generated table border attributes so we can style it correctly

        (0, _syntaxHighlight.highlightContainer)($container);
        _mathjax2.default.typeset();
    };

    var handle = exports.handle = function handle(_ref) {
        var $container = _ref.$container,
            fileChange = _ref.fileChange;
        return _jquery2.default.when((0, _requestSource2.default)(fileChange), (0, _requestSource2.default)(fileChange, { getSize: true })).then(function (source, _ref2) {
            var fileSize = _ref2.size;

            var anyLinesTruncated = source.lines.some(function (line) {
                return line.truncated;
            });

            if (!anyLinesTruncated && source.isLastPage) {
                return source.lines.map(function (line) {
                    return line.text;
                }).join('\n');
            }

            if (fileSize > MAX_NOTEBOOK_SIZE) {
                //Don't load the raw file automatically
                $container.html(bitbucket.internal.feature.jupyterNotebookFileHandler.largeNotebook({
                    maxNotebookSize: MAX_NOTEBOOK_SIZE
                }));

                $container.find('#load-large-notebook-button').click(function () {
                    $container.html(bitbucket.internal.feature.jupyterNotebookFileHandler.largeNotebookLoading({
                        rawUrl: getRawFileUrl(fileChange)
                    }));

                    fetchRawNotebook(fileChange).then(function (notebookText) {
                        try {
                            var notebook = _notebookjs2.default.parse(JSON.parse(notebookText));
                            renderNotebook(notebook, $container);
                        } catch (e) {
                            $container.html(bitbucket.internal.feature.jupyterNotebookFileHandler.unableToRender());

                            $container.find('#show-notebook-source-button').click(function () {
                                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.feature.fileContent.useDefaultHandler');
                            });
                        }
                    });
                });

                return null;
            }

            return fetchRawNotebook(fileChange);
        }).then(function (notebookText) {
            if (notebookText != null) {
                try {
                    var notebook = _notebookjs2.default.parse(JSON.parse(notebookText));
                    renderNotebook(notebook, $container);
                } catch (e) {
                    return _jquery2.default.Deferred().reject(_i18n.I18n.getText('bitbucket.web.file.content.jupyter.notebook.unable.to.render.error'));
                }
            }

            return { handlerId: handlerId, extraClasses: handlerDOMClass };
        });
    };

    //Exported for testing
    exports._handlerId = handlerId;
    exports._handlerDOMClass = handlerDOMClass;
});