define('bitbucket/internal/feature/jupyter-notebook-file-handler/jupyter-notebook-file-handler.test', ['jquery', 'mathjax', 'notebookjs', 'bitbucket/internal/feature/file-content/file-content-modes', 'bitbucket/internal/feature/file-content/request-source', 'bitbucket/internal/util/property', 'bitbucket/internal/util/syntax-highlight/syntax-highlight', 'bitbucket/util/server', './jupyter-notebook-file-handler', './jupyter-notebook-file-handler.test-data'], function (_jquery, _mathjax, _notebookjs, _fileContentModes, _requestSource, _property, _syntaxHighlight, _server, _jupyterNotebookFileHandler, _jupyterNotebookFileHandler2) {
    'use strict';

    var _jquery2 = _interopRequireDefault(_jquery);

    var _mathjax2 = _interopRequireDefault(_mathjax);

    var _notebookjs2 = _interopRequireDefault(_notebookjs);

    var _fileContentModes2 = _interopRequireDefault(_fileContentModes);

    var _requestSource2 = _interopRequireDefault(_requestSource);

    var _property2 = _interopRequireDefault(_property);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _asyncToGenerator(fn) {
        return function () {
            var gen = fn.apply(this, arguments);
            return new Promise(function (resolve, reject) {
                function step(key, arg) {
                    try {
                        var info = gen[key](arg);
                        var value = info.value;
                    } catch (error) {
                        reject(error);
                        return;
                    }

                    if (info.done) {
                        resolve(value);
                    } else {
                        return Promise.resolve(value).then(function (value) {
                            step("next", value);
                        }, function (err) {
                            step("throw", err);
                        });
                    }
                }

                return step("next");
            });
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    jest.mock('mathjax', function () {
        return {
            typeset: jest.fn()
        };
    });
    jest.mock('bitbucket/util/server', function () {
        return _extends({}, jest.requireActual('bitbucket/util/server'), {
            rest: jest.fn()
        });
    });
    jest.mock('bitbucket/internal/feature/file-content/request-source');
    jest.mock('bitbucket/internal/util/syntax-highlight/syntax-highlight', function () {
        return {
            highlightContainer: jest.fn()
        };
    });
    jest.mock('bitbucket/internal/util/property');

    //Mock soy templates
    global.bitbucket = {
        internal: {
            feature: {
                jupyterNotebookFileHandler: {
                    largeNotebook: jest.fn(function () {
                        return '<div class="large-notebook"><button id="load-large-notebook-button">Load Notebook</button></div>';
                    }),
                    largeNotebookLoading: jest.fn(function () {
                        return '<div class="large-notebook"><aui-spinner size="large"/></div>';
                    }),
                    unableToRender: jest.fn(function () {
                        return '<div class="unable-to-render-notebook"></div>';
                    })
                }
            }
        }
    };

    beforeEach(function () {
        _requestSource2.default.mockReset().mockReturnValue(Promise.resolve({}));
        _server.rest.mockReset().mockReturnValue(Promise.resolve({}));
        _syntaxHighlight.highlightContainer.mockReset().mockImplementation(function () {});
        _mathjax2.default.typeset.mockReset().mockImplementation(function () {});
    });

    var lines = [{ text: '{' }, { text: '"cells": [' }, { text: '{' }, { text: '"cell_type": "markdown",' }, { text: '"metadata": {},' }, { text: '"source": [' }, { text: '"# matplotlib - 2D and 3D plotting in Python"' }, { text: ']' }, { text: '}' }, { text: ']' }, { text: '}' }];

    var JSONLines = {
        cells: [{
            cell_type: 'markdown',
            metadata: {},
            source: ['# matplotlib - 2D and 3D plotting in Python']
        }]
    };

    describe(_jupyterNotebookFileHandler.handle, function () {
        it('works for source with no truncation', _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
            var nbParseSpy, $container, htmlSpy, handler;
            return regeneratorRuntime.wrap(function _callee$(_context) {
                while (1) {
                    switch (_context.prev = _context.next) {
                        case 0:
                            _requestSource2.default.mockImplementation(function (fileChange) {
                                var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                                    getSize = _ref2.getSize;

                                return _jquery2.default.Deferred().resolve(getSize ? { size: 1 } : {
                                    lines: lines,
                                    isLastPage: true
                                });
                            });

                            nbParseSpy = jest.spyOn(_notebookjs2.default, 'parse');
                            $container = (0, _jquery2.default)('<div/>');
                            htmlSpy = jest.spyOn($container, 'html');


                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).not.toBeCalled();
                            expect(htmlSpy).not.toBeCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            _context.next = 11;
                            return (0, _jupyterNotebookFileHandler.handle)({
                                $container: $container,
                                contentMode: _fileContentModes2.default.SOURCE,
                                fileChange: {
                                    commitRange: {
                                        untilRevision: {
                                            id: 'DEADBEEF'
                                        }
                                    },
                                    path: {
                                        components: ['my', 'test.ipynb'],
                                        extension: 'ipynb'
                                    },
                                    repository: {
                                        slug: 'test',
                                        project: {
                                            key: 'TEST'
                                        }
                                    }
                                }
                            });

                        case 11:
                            handler = _context.sent;

                            expect(handler).toEqual({ handlerId: _jupyterNotebookFileHandler._handlerId, extraClasses: _jupyterNotebookFileHandler._handlerDOMClass });
                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).toHaveBeenCalledWith(JSONLines);
                            expect(htmlSpy.mock.calls[0][0]).toMatchSnapshot();
                            expect(_syntaxHighlight.highlightContainer).toHaveBeenCalledWith($container);
                            expect(_mathjax2.default.typeset).toHaveBeenCalled();

                            nbParseSpy.mockRestore();

                        case 19:
                        case 'end':
                            return _context.stop();
                    }
                }
            }, _callee, undefined);
        })));

        it('sanitizes svg and latext img with onerror xss', _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
            var unsanitizedLines, nbParseSpy, $container, htmlSpy, handler;
            return regeneratorRuntime.wrap(function _callee2$(_context2) {
                while (1) {
                    switch (_context2.prev = _context2.next) {
                        case 0:
                            unsanitizedLines = [{ text: '{' }, { text: '"cells": [' }, { text: '{' }, { text: '"cell_type": "markdown",' }, { text: '"metadata": {},' }, { text: '"source": [' }, { text: '"# matplotlib - 2D and 3D plotting in Python"' }, { text: '],' }, { text: '"outputs": [' }, { text: '{' }, { text: '"data": {' }, { text: '"text/svg+xml": [' }, { text: '"<img src onerror=\'alert(\\"XSS at text/svg+xml\\")\'>"' }, { text: ']' }, { text: '},' }, { text: '"metadata": {},' }, { text: '"output_type": "display_data"' }, { text: '},' }, { text: '{' }, { text: '"data": {' }, { text: '"image/svg+xml":' }, { text: '"<img src onerror=\'alert(\\"XSS at text/svg+xml\\")\'>"' }, { text: '},' }, { text: '"metadata": {},' }, { text: '"output_type": "display_data"' }, { text: '},' }, { text: '{' }, { text: '"data": {' }, { text: '"text/latex": [' }, { text: '"<img src onerror=\'alert(\\"XSS at text/svg+xml\\")\'>"' }, { text: ']' }, { text: '},' }, { text: '"metadata": {},' }, { text: '"output_type": "display_data"' }, { text: '}' }, { text: ']' }, { text: '}' }, { text: ']' }, { text: '}' }];


                            _requestSource2.default.mockImplementation(function (fileChange) {
                                var _ref4 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                                    getSize = _ref4.getSize;

                                return _jquery2.default.Deferred().resolve(getSize ? { size: 1 } : {
                                    lines: unsanitizedLines,
                                    isLastPage: true
                                });
                            });

                            nbParseSpy = jest.spyOn(_notebookjs2.default, 'parse');
                            $container = (0, _jquery2.default)('<div/>');
                            htmlSpy = jest.spyOn($container, 'html');
                            _context2.next = 7;
                            return (0, _jupyterNotebookFileHandler.handle)({
                                $container: $container,
                                contentMode: _fileContentModes2.default.SOURCE,
                                fileChange: {
                                    commitRange: {
                                        untilRevision: {
                                            id: 'DEADBEEF'
                                        }
                                    },
                                    path: {
                                        components: ['my', 'test.ipynb'],
                                        extension: 'ipynb'
                                    },
                                    repository: {
                                        slug: 'test',
                                        project: {
                                            key: 'TEST'
                                        }
                                    }
                                }
                            });

                        case 7:
                            handler = _context2.sent;

                            expect(handler).toEqual({ handlerId: _jupyterNotebookFileHandler._handlerId, extraClasses: _jupyterNotebookFileHandler._handlerDOMClass });
                            expect(_server.rest).not.toHaveBeenCalled();
                            expect(nbParseSpy).toHaveBeenCalled();
                            expect(htmlSpy.mock.calls[0][0]).toMatchSnapshot();
                            expect(_syntaxHighlight.highlightContainer).toHaveBeenCalledWith($container);
                            expect(_mathjax2.default.typeset).toHaveBeenCalled();

                            //XSS removal
                            expect($container.find('script')).toHaveLength(0);
                            expect($container.find('img')).toHaveLength(0);
                            expect($container.find('img').attr('onError')).toBeUndefined();
                            expect($container.find('img').attr('onerror')).toBeUndefined();

                            nbParseSpy.mockRestore();

                        case 19:
                        case 'end':
                            return _context2.stop();
                    }
                }
            }, _callee2, undefined);
        })));

        it('removes unsafe html in latex field from the rendered output', _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
            var nbParseSpy, $container, htmlSpy, handler;
            return regeneratorRuntime.wrap(function _callee3$(_context3) {
                while (1) {
                    switch (_context3.prev = _context3.next) {
                        case 0:
                            _requestSource2.default.mockImplementation(function (fileChange) {
                                var _ref6 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                                    getSize = _ref6.getSize;

                                return _jquery2.default.Deferred().resolve(getSize ? { size: 1 } : {
                                    lines: _jupyterNotebookFileHandler2.xssViaLatexLines,
                                    isLastPage: true
                                });
                            });

                            nbParseSpy = jest.spyOn(_notebookjs2.default, 'parse');
                            $container = (0, _jquery2.default)('<div/>');
                            htmlSpy = jest.spyOn($container, 'html');


                            expect(_server.rest).not.toHaveBeenCalled();
                            expect(nbParseSpy).not.toHaveBeenCalled();
                            expect(htmlSpy).not.toHaveBeenCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toHaveBeenCalled();
                            expect(_mathjax2.default.typeset).not.toHaveBeenCalled();

                            _context3.next = 11;
                            return (0, _jupyterNotebookFileHandler.handle)({
                                $container: $container,
                                contentMode: _fileContentModes2.default.SOURCE,
                                fileChange: {
                                    commitRange: {
                                        untilRevision: {
                                            id: 'DEADBEEF'
                                        }
                                    },
                                    path: {
                                        components: ['my', 'test.ipynb'],
                                        extension: 'ipynb'
                                    },
                                    repository: {
                                        slug: 'test',
                                        project: {
                                            key: 'TEST'
                                        }
                                    }
                                }
                            });

                        case 11:
                            handler = _context3.sent;


                            expect(handler).toEqual({ handlerId: _jupyterNotebookFileHandler._handlerId, extraClasses: _jupyterNotebookFileHandler._handlerDOMClass });
                            expect(_server.rest).not.toHaveBeenCalled();
                            expect(nbParseSpy).toHaveBeenCalledWith(_jupyterNotebookFileHandler2.xssViaLatexJSON);
                            expect(htmlSpy.mock.calls[0][0]).toMatchSnapshot();
                            expect(_syntaxHighlight.highlightContainer).toHaveBeenCalledWith($container);
                            expect(_mathjax2.default.typeset).toHaveBeenCalled();

                            //XSS removal
                            expect($container.find('img')).toHaveLength(0);
                            expect($container.find('img').attr('onError')).toBeUndefined();
                            expect($container.find('img').attr('onerror')).toBeUndefined();

                            nbParseSpy.mockRestore();

                        case 22:
                        case 'end':
                            return _context3.stop();
                    }
                }
            }, _callee3, undefined);
        })));

        it('works for source with truncated lines', _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
            var truncatedLines, nbParseSpy, $container, htmlSpy, rawUrl, handler;
            return regeneratorRuntime.wrap(function _callee4$(_context4) {
                while (1) {
                    switch (_context4.prev = _context4.next) {
                        case 0:
                            truncatedLines = lines.map(function (line) {
                                return _extends({}, line, { truncated: true });
                            });


                            _requestSource2.default.mockImplementation(function (fileChange) {
                                var _ref8 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                                    getSize = _ref8.getSize;

                                return _jquery2.default.Deferred().resolve(getSize ? { size: 1 } : {
                                    lines: truncatedLines,
                                    isLastPage: true
                                });
                            });

                            _server.rest.mockReturnValue(_jquery2.default.Deferred().resolve(JSON.stringify(JSONLines)));

                            nbParseSpy = jest.spyOn(_notebookjs2.default, 'parse');
                            $container = (0, _jquery2.default)('<div/>');
                            htmlSpy = jest.spyOn($container, 'html');
                            rawUrl = '/stash/projects/TEST/repos/test/raw/my/test.ipynb?at=DEADBEEF';


                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).not.toBeCalled();
                            expect(htmlSpy).not.toBeCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            _context4.next = 14;
                            return (0, _jupyterNotebookFileHandler.handle)({
                                $container: $container,
                                contentMode: _fileContentModes2.default.SOURCE,
                                fileChange: {
                                    commitRange: {
                                        untilRevision: {
                                            id: 'DEADBEEF'
                                        }
                                    },
                                    path: {
                                        components: ['my', 'test.ipynb'],
                                        extension: 'ipynb'
                                    },
                                    repository: {
                                        slug: 'test',
                                        project: {
                                            key: 'TEST'
                                        }
                                    }
                                }
                            });

                        case 14:
                            handler = _context4.sent;

                            expect(handler).toEqual({ handlerId: _jupyterNotebookFileHandler._handlerId, extraClasses: _jupyterNotebookFileHandler._handlerDOMClass });
                            expect(_server.rest).toHaveBeenCalledWith({
                                accepts: '*/*',
                                dataType: 'text',
                                url: rawUrl
                            });
                            expect(nbParseSpy).toHaveBeenCalledWith(JSONLines);
                            expect(htmlSpy.mock.calls[0][0]).toMatchSnapshot();
                            expect(_syntaxHighlight.highlightContainer).toHaveBeenCalledWith($container);
                            expect(_mathjax2.default.typeset).toHaveBeenCalled();

                            nbParseSpy.mockRestore();

                        case 22:
                        case 'end':
                            return _context4.stop();
                    }
                }
            }, _callee4, undefined);
        })));

        it('works for truncated source', _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
            var nbParseSpy, $container, htmlSpy, rawUrl, handler;
            return regeneratorRuntime.wrap(function _callee5$(_context5) {
                while (1) {
                    switch (_context5.prev = _context5.next) {
                        case 0:
                            _requestSource2.default.mockImplementation(function (fileChange) {
                                var _ref10 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                                    getSize = _ref10.getSize;

                                return _jquery2.default.Deferred().resolve(getSize ? { size: 1 } : {
                                    lines: lines,
                                    isLastPage: false
                                });
                            });

                            _server.rest.mockReturnValue(_jquery2.default.Deferred().resolve(JSON.stringify(JSONLines)));

                            nbParseSpy = jest.spyOn(_notebookjs2.default, 'parse');
                            $container = (0, _jquery2.default)('<div/>');
                            htmlSpy = jest.spyOn($container, 'html');
                            rawUrl = '/stash/projects/TEST/repos/test/raw/my/test.ipynb?at=DEADBEEF';


                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).not.toBeCalled();
                            expect(htmlSpy).not.toBeCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            _context5.next = 13;
                            return (0, _jupyterNotebookFileHandler.handle)({
                                $container: $container,
                                contentMode: _fileContentModes2.default.SOURCE,
                                fileChange: {
                                    commitRange: {
                                        untilRevision: {
                                            id: 'DEADBEEF'
                                        }
                                    },
                                    path: {
                                        components: ['my', 'test.ipynb'],
                                        extension: 'ipynb'
                                    },
                                    repository: {
                                        slug: 'test',
                                        project: {
                                            key: 'TEST'
                                        }
                                    }
                                }
                            });

                        case 13:
                            handler = _context5.sent;

                            expect(handler).toEqual({ handlerId: _jupyterNotebookFileHandler._handlerId, extraClasses: _jupyterNotebookFileHandler._handlerDOMClass });
                            expect(_server.rest).toHaveBeenCalledWith({
                                accepts: '*/*',
                                dataType: 'text',
                                url: rawUrl
                            });
                            expect(nbParseSpy).toHaveBeenCalledWith(JSONLines);
                            expect(htmlSpy.mock.calls[0][0]).toMatchSnapshot();
                            expect(_syntaxHighlight.highlightContainer).toHaveBeenCalledWith($container);
                            expect(_mathjax2.default.typeset).toHaveBeenCalled();

                            nbParseSpy.mockRestore();

                        case 21:
                        case 'end':
                            return _context5.stop();
                    }
                }
            }, _callee5, undefined);
        })));

        it('works for very large truncated source', _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6() {
            var nbParseSpy, $container, htmlSpy, rawUrl, handler;
            return regeneratorRuntime.wrap(function _callee6$(_context6) {
                while (1) {
                    switch (_context6.prev = _context6.next) {
                        case 0:
                            _requestSource2.default.mockImplementation(function (fileChange) {
                                var _ref12 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                                    getSize = _ref12.getSize;

                                return _jquery2.default.Deferred().resolve(getSize ? {
                                    size: _property2.default.getFromProviderSync('display.max.jupyter.notebook.size') + 1
                                } : {
                                    lines: lines,
                                    isLastPage: false
                                });
                            });

                            _server.rest.mockReturnValue(Promise.resolve(JSON.stringify(JSONLines)));

                            nbParseSpy = jest.spyOn(_notebookjs2.default, 'parse');
                            $container = (0, _jquery2.default)('<div/>');
                            htmlSpy = jest.spyOn($container, 'html');
                            rawUrl = '/stash/projects/TEST/repos/test/raw/my/test.ipynb?at=DEADBEEF';


                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).not.toBeCalled();
                            expect(htmlSpy).not.toBeCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            _context6.next = 13;
                            return (0, _jupyterNotebookFileHandler.handle)({
                                $container: $container,
                                contentMode: _fileContentModes2.default.SOURCE,
                                fileChange: {
                                    commitRange: {
                                        untilRevision: {
                                            id: 'DEADBEEF'
                                        }
                                    },
                                    path: {
                                        components: ['my', 'test.ipynb'],
                                        extension: 'ipynb'
                                    },
                                    repository: {
                                        slug: 'test',
                                        project: {
                                            key: 'TEST'
                                        }
                                    }
                                }
                            });

                        case 13:
                            handler = _context6.sent;

                            expect(handler).toEqual({ handlerId: _jupyterNotebookFileHandler._handlerId, extraClasses: _jupyterNotebookFileHandler._handlerDOMClass });

                            expect(htmlSpy.mock.calls[0][0]).toMatchSnapshot();
                            expect(bitbucket.internal.feature.jupyterNotebookFileHandler.largeNotebook).toBeCalledWith({
                                maxNotebookSize: 2097152
                            });

                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).not.toBeCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            $container.find('#load-large-notebook-button').trigger('click');

                            expect(htmlSpy.mock.calls[1][0]).toMatchSnapshot();
                            expect(bitbucket.internal.feature.jupyterNotebookFileHandler.largeNotebookLoading).toHaveBeenCalledWith({ rawUrl: rawUrl });

                            expect(_server.rest).toHaveBeenCalledWith({
                                accepts: '*/*',
                                dataType: 'text',
                                url: rawUrl
                            });
                            // Wait for mock rest promise to resolve
                            _context6.next = 27;
                            return new Promise(setImmediate);

                        case 27:

                            expect(nbParseSpy).toHaveBeenCalledWith(JSONLines);
                            expect(htmlSpy.mock.calls[2][0]).toMatchSnapshot();
                            expect(_syntaxHighlight.highlightContainer).toHaveBeenCalledWith($container);
                            expect(_mathjax2.default.typeset).toHaveBeenCalled();

                            nbParseSpy.mockRestore();

                        case 32:
                        case 'end':
                            return _context6.stop();
                    }
                }
            }, _callee6, undefined);
        })));

        it('removes unsafe html from the rendered output', _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7() {
            var nbParseSpy, $container, htmlSpy, handler;
            return regeneratorRuntime.wrap(function _callee7$(_context7) {
                while (1) {
                    switch (_context7.prev = _context7.next) {
                        case 0:
                            _requestSource2.default.mockImplementation(function (fileChange) {
                                var _ref14 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                                    getSize = _ref14.getSize;

                                return _jquery2.default.Deferred().resolve(getSize ? { size: 1 } : {
                                    lines: _jupyterNotebookFileHandler2.xssLines,
                                    isLastPage: true
                                });
                            });

                            nbParseSpy = jest.spyOn(_notebookjs2.default, 'parse');
                            $container = (0, _jquery2.default)('<div/>');
                            htmlSpy = jest.spyOn($container, 'html');


                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).not.toBeCalled();
                            expect(htmlSpy).not.toBeCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            _context7.next = 11;
                            return (0, _jupyterNotebookFileHandler.handle)({
                                $container: $container,
                                contentMode: _fileContentModes2.default.SOURCE,
                                fileChange: {
                                    commitRange: {
                                        untilRevision: {
                                            id: 'DEADBEEF'
                                        }
                                    },
                                    path: {
                                        components: ['my', 'test.ipynb'],
                                        extension: 'ipynb'
                                    },
                                    repository: {
                                        slug: 'test',
                                        project: {
                                            key: 'TEST'
                                        }
                                    }
                                }
                            });

                        case 11:
                            handler = _context7.sent;

                            expect(handler).toEqual({ handlerId: _jupyterNotebookFileHandler._handlerId, extraClasses: _jupyterNotebookFileHandler._handlerDOMClass });
                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).toHaveBeenCalledWith(_jupyterNotebookFileHandler2.xssJson);
                            expect(htmlSpy.mock.calls[0][0]).toMatchSnapshot();
                            expect(_syntaxHighlight.highlightContainer).toHaveBeenCalledWith($container);
                            expect(_mathjax2.default.typeset).toHaveBeenCalled();

                            //XSS removal
                            expect($container.find('script')).toHaveLength(0);
                            expect($container.find('img.image-bad-onerror')).toHaveLength(1);
                            expect($container.find('img.image-bad-onerror').attr('onError')).toBeUndefined();
                            expect($container.find('h1.do-not-remove')).toHaveLength(1);

                            nbParseSpy.mockRestore();

                        case 23:
                        case 'end':
                            return _context7.stop();
                    }
                }
            }, _callee7, undefined);
        })));

        it('returns an error for invalid JSON from non-truncated source', _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8() {
            var nbParseSpy, $container, htmlSpy;
            return regeneratorRuntime.wrap(function _callee8$(_context8) {
                while (1) {
                    switch (_context8.prev = _context8.next) {
                        case 0:
                            _requestSource2.default.mockImplementation(function (fileChange) {
                                var _ref16 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                                    getSize = _ref16.getSize;

                                return _jquery2.default.Deferred().resolve(getSize ? { size: 1 } : {
                                    lines: lines.slice(1), //remove the first line so it's invalid JSON
                                    isLastPage: true
                                });
                            });

                            nbParseSpy = jest.spyOn(_notebookjs2.default, 'parse');
                            $container = (0, _jquery2.default)('<div/>');
                            htmlSpy = jest.spyOn($container, 'html');


                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).not.toBeCalled();
                            expect(htmlSpy).not.toBeCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            _context8.prev = 9;
                            _context8.next = 12;
                            return (0, _jupyterNotebookFileHandler.handle)({
                                $container: $container,
                                contentMode: _fileContentModes2.default.SOURCE,
                                fileChange: {
                                    commitRange: {
                                        untilRevision: {
                                            id: 'DEADBEEF'
                                        }
                                    },
                                    path: {
                                        components: ['my', 'test.ipynb'],
                                        extension: 'ipynb'
                                    },
                                    repository: {
                                        slug: 'test',
                                        project: {
                                            key: 'TEST'
                                        }
                                    }
                                }
                            });

                        case 12:
                            _context8.next = 23;
                            break;

                        case 14:
                            _context8.prev = 14;
                            _context8.t0 = _context8['catch'](9);

                            expect(_context8.t0).toEqual('bitbucket.web.file.content.jupyter.notebook.unable.to.render.error');
                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).not.toBeCalled();
                            expect(htmlSpy).not.toBeCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            nbParseSpy.mockRestore();

                        case 23:
                        case 'end':
                            return _context8.stop();
                    }
                }
            }, _callee8, undefined, [[9, 14]]);
        })));

        it('returns an error for invalid JSON from truncated source', _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9() {
            var nbParseSpy, $container, htmlSpy, rawUrl;
            return regeneratorRuntime.wrap(function _callee9$(_context9) {
                while (1) {
                    switch (_context9.prev = _context9.next) {
                        case 0:
                            _requestSource2.default.mockImplementation(function (fileChange) {
                                var _ref18 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                                    getSize = _ref18.getSize;

                                return _jquery2.default.Deferred().resolve(getSize ? { size: 1 } : {
                                    lines: lines,
                                    isLastPage: false
                                });
                            });

                            //Prepend the JSON string with 'BAD' to make it unparseable
                            _server.rest.mockReturnValue(_jquery2.default.Deferred().resolve('BAD' + JSON.stringify(JSONLines)));

                            nbParseSpy = jest.spyOn(_notebookjs2.default, 'parse');
                            $container = (0, _jquery2.default)('<div/>');
                            htmlSpy = jest.spyOn($container, 'html');
                            rawUrl = '/stash/projects/TEST/repos/test/raw/my/test.ipynb?at=DEADBEEF';


                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).not.toBeCalled();
                            expect(htmlSpy).not.toBeCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            _context9.prev = 11;
                            _context9.next = 14;
                            return (0, _jupyterNotebookFileHandler.handle)({
                                $container: $container,
                                contentMode: _fileContentModes2.default.SOURCE,
                                fileChange: {
                                    commitRange: {
                                        untilRevision: {
                                            id: 'DEADBEEF'
                                        }
                                    },
                                    path: {
                                        components: ['my', 'test.ipynb'],
                                        extension: 'ipynb'
                                    },
                                    repository: {
                                        slug: 'test',
                                        project: {
                                            key: 'TEST'
                                        }
                                    }
                                }
                            });

                        case 14:
                            _context9.next = 25;
                            break;

                        case 16:
                            _context9.prev = 16;
                            _context9.t0 = _context9['catch'](11);

                            expect(_context9.t0).toEqual('bitbucket.web.file.content.jupyter.notebook.unable.to.render.error');
                            expect(_server.rest).toHaveBeenCalledWith({
                                accepts: '*/*',
                                dataType: 'text',
                                url: rawUrl
                            });
                            expect(nbParseSpy).not.toBeCalled();
                            expect(htmlSpy).not.toBeCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            nbParseSpy.mockRestore();

                        case 25:
                        case 'end':
                            return _context9.stop();
                    }
                }
            }, _callee9, undefined, [[11, 16]]);
        })));

        it('renders an error for invalid JSON from a very large truncated source', _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee10() {
            var nbParseSpy, $container, htmlSpy, rawUrl, handler;
            return regeneratorRuntime.wrap(function _callee10$(_context10) {
                while (1) {
                    switch (_context10.prev = _context10.next) {
                        case 0:
                            _requestSource2.default.mockImplementation(function (fileChange) {
                                var _ref20 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                                    getSize = _ref20.getSize;

                                return _jquery2.default.Deferred().resolve(getSize ? {
                                    size: _property2.default.getFromProviderSync('display.max.jupyter.notebook.size') + 1
                                } : {
                                    lines: lines,
                                    isLastPage: false
                                });
                            });

                            //Prepend the JSON string with 'BAD' to make it unparseable
                            _server.rest.mockReturnValue(Promise.resolve('BAD' + JSON.stringify(JSONLines)));

                            nbParseSpy = jest.spyOn(_notebookjs2.default, 'parse');
                            $container = (0, _jquery2.default)('<div/>');
                            htmlSpy = jest.spyOn($container, 'html');
                            rawUrl = '/stash/projects/TEST/repos/test/raw/my/test.ipynb?at=DEADBEEF';


                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).not.toBeCalled();
                            expect(htmlSpy).not.toBeCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            _context10.next = 13;
                            return (0, _jupyterNotebookFileHandler.handle)({
                                $container: $container,
                                contentMode: _fileContentModes2.default.SOURCE,
                                fileChange: {
                                    commitRange: {
                                        untilRevision: {
                                            id: 'DEADBEEF'
                                        }
                                    },
                                    path: {
                                        components: ['my', 'test.ipynb'],
                                        extension: 'ipynb'
                                    },
                                    repository: {
                                        slug: 'test',
                                        project: {
                                            key: 'TEST'
                                        }
                                    }
                                }
                            });

                        case 13:
                            handler = _context10.sent;

                            expect(handler).toEqual({ handlerId: _jupyterNotebookFileHandler._handlerId, extraClasses: _jupyterNotebookFileHandler._handlerDOMClass });

                            expect(htmlSpy.mock.calls[0][0]).toMatchSnapshot();
                            expect(bitbucket.internal.feature.jupyterNotebookFileHandler.largeNotebook).toBeCalledWith({
                                maxNotebookSize: 2097152
                            });

                            expect(_server.rest).not.toBeCalled();
                            expect(nbParseSpy).not.toBeCalled();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            $container.find('#load-large-notebook-button').click();

                            expect(htmlSpy.mock.calls[1][0]).toMatchSnapshot();
                            expect(bitbucket.internal.feature.jupyterNotebookFileHandler.largeNotebookLoading).toBeCalledWith({ rawUrl: rawUrl });

                            expect(_server.rest).toHaveBeenCalledWith({
                                accepts: '*/*',
                                dataType: 'text',
                                url: rawUrl
                            });

                            // Wait for mock rest promise to resolve
                            _context10.next = 27;
                            return new Promise(setImmediate);

                        case 27:

                            expect(nbParseSpy).not.toBeCalled();
                            expect(htmlSpy.mock.calls[2][0]).toMatchSnapshot();
                            expect(_syntaxHighlight.highlightContainer).not.toBeCalled();
                            expect(_mathjax2.default.typeset).not.toBeCalled();

                            nbParseSpy.mockRestore();

                        case 32:
                        case 'end':
                            return _context10.stop();
                    }
                }
            }, _callee10, undefined);
        })));
    });
});