define('bitbucket/internal/feature/labels/repository/label-repositories-dialog', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/bbui/aui-react/dialog', 'bitbucket/internal/util/i18n-html', 'bitbucket/util/server', './label-repositories-dialog-content'], function (module, exports, _aui, _propTypes, _react, _dialog, _i18nHtml, _server, _labelRepositoriesDialogContent) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _i18nHtml2 = _interopRequireDefault(_i18nHtml);

    var _labelRepositoriesDialogContent2 = _interopRequireDefault(_labelRepositoriesDialogContent);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var LabelRepositoriesDialog = function (_Component) {
        _inherits(LabelRepositoriesDialog, _Component);

        function LabelRepositoriesDialog() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, LabelRepositoriesDialog);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = LabelRepositoriesDialog.__proto__ || Object.getPrototypeOf(LabelRepositoriesDialog)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
                dialogRendered: false
            }, _this.dialogElRef = _react2.default.createRef(), _this.dialogContentEl = null, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(LabelRepositoriesDialog, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.dialogContentEl = (0, _dialog.getDialogContent)(this.dialogElRef.current);

                this.setState({
                    dialogRendered: true
                });
            }
        }, {
            key: 'getTitle',
            value: function getTitle() {
                return _react2.default.createElement(
                    _i18nHtml2.default.p,
                    {
                        params: [this.props.labelName],
                        className: 'label-repositories-dialog__title'
                    },
                    _aui.I18n.getText('bitbucket.web.label.search.title')
                );
            }
        }, {
            key: 'render',
            value: function render() {
                var dialogRendered = this.state.dialogRendered;


                var dialogContent = dialogRendered ? _react2.default.createElement(_labelRepositoriesDialogContent2.default, {
                    labelName: this.props.labelName,
                    dialogContentEl: this.dialogContentEl
                }) : null;

                return _react2.default.createElement(
                    _dialog.DialogWithRef,
                    {
                        size: _dialog.DialogSize.LARGE,
                        titleContent: this.getTitle(),
                        onClose: this.props.onCancel,
                        className: 'label-repositories-dialog',
                        ref: this.dialogElRef
                    },
                    dialogContent
                );
            }
        }]);

        return LabelRepositoriesDialog;
    }(_react.Component);

    LabelRepositoriesDialog.propTypes = {
        labelName: _propTypes2.default.string.isRequired,
        onCancel: _propTypes2.default.func.isRequired
    };
    exports.default = LabelRepositoriesDialog;
    module.exports = exports['default'];
});