define('bitbucket/internal/feature/permission/multi-selector/multi-selector', ['module', 'exports', '@atlassian/aui', '@atlassian/backbone-brace', 'jquery', 'lodash', 'bitbucket/internal/feature/user/group-multi-selector/group-multi-selector', 'bitbucket/internal/feature/user/user-multi-selector/user-multi-selector'], function (module, exports, _aui, _backboneBrace, _jquery, _lodash, _groupMultiSelector, _userMultiSelector) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _backboneBrace2 = _interopRequireDefault(_backboneBrace);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _groupMultiSelector2 = _interopRequireDefault(_groupMultiSelector);

    var _userMultiSelector2 = _interopRequireDefault(_userMultiSelector);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var entityTypeToSelectorConstructor = {
        user: _userMultiSelector2.default,
        group: _groupMultiSelector2.default
    };

    function createGetSelected(delegate, entityType) {
        return function () {
            return _lodash2.default.map(delegate(), entityType);
        };
    }

    var PermissionMultiSelector = _backboneBrace2.default.View.extend({
        events: {
            'click .add-button': '_onClickAdd'
        },

        /**
         * @param {Object} options the options available to the PermissionMultiSelector. Valid options are:
         *
         * * {String}   entityType (required) either 'user' or 'group'
         * * {String}   url        (required) the REST resource to search
         * * {Function} add        (required) the callback to be invoked when the add button is clicked
         *
         */
        initialize: function initialize(options) {
            this.options = options || {};

            var $field = this.$el.find('.permission-multi-selector');
            this._$addButton = this.$el.find('.add-button');

            var DelegateMultiSelector = entityTypeToSelectorConstructor[this.options.entityType];

            if (!DelegateMultiSelector) {
                throw new Error('Unknown entity type: ' + this.options.entityType);
            }
            this._delegate = new DelegateMultiSelector($field, {
                dataSource: this.options.dataSource
            });

            if (!_lodash2.default.isFunction(this.options.add)) {
                throw new Error('must provide an add function');
            }

            // This must be bound on the dropdown as it is moved around the DOM
            var $dropdown = this.$el.find('.permission-type-dropdown');
            $dropdown.on('click', 'a', _lodash2.default.bind(this._onSelectPermission, this));

            this._permission = $dropdown.find('li:first-child').attr('data-value');

            this._delegate.on('change', _lodash2.default.bind(this._onChangeEntitySelection, this));
            this._onChangeEntitySelection();

            this.$el.on('keydown', _lodash2.default.bind(function (e) {
                // If a keydown event bubbles up to the container from the multi-select
                // then We should add the selected. This allows for easier use of the selector
                // via the keyboard
                if (e.which === AJS.keyCode.ENTER && e.target.tagName === 'INPUT' && this.getSelected().length) {
                    e.preventDefault();
                    this._addSelected();
                }
            }, this));
        },
        getSelected: function getSelected() {
            return this._delegate.getSelectedItems();
        },
        getPermission: function getPermission() {
            return this._permission;
        },
        showError: function showError(data) {
            this.clearError();
            var $errors = this._$errors = (0, _jquery2.default)('<ul class="error-message"></ul>');
            var errors = _lodash2.default.get(data, 'errors.length') ? data.errors : [{
                message: AJS.I18n.getText('bitbucket.web.permission.multiselector.unexpected.error')
            }];
            _lodash2.default.forEach(errors, function (error) {
                var escapedMessage = AJS.escapeHtml(error.message);
                var escapedDetails = error.details ? ' ' + AJS.escapeHtml(error.details[0]) : '';
                var errorMessage = escapedMessage + escapedDetails;
                (0, _jquery2.default)('<li><span class="aui-icon aui-icon-small aui-iconfont-error"></span>' + errorMessage + '</li>').appendTo($errors);
            });
            $errors.appendTo(this.$el.children('th'));
        },
        clearError: function clearError() {
            if (this._$errors) {
                this._$errors.remove();
                this._$errors = null;
            }
        },
        clear: function clear() {
            this.clearError();
            this._delegate.clearSelectedItems();
            this._setAddButtonDisabled(true);
        },
        _addSelected: function _addSelected() {
            this._setAddButtonDisabled(true);
            _jquery2.default.when(this.options.add({
                entities: this.getSelected(),
                permission: this.getPermission()
            })).always(_lodash2.default.bind(this._setAddButtonDisabled, this, false)).done(_lodash2.default.bind(this.clear, this)).fail(_lodash2.default.bind(function (xhr, statusText, errorType, data) {
                this.showError(data);
            }, this));
        },
        _setAddButtonDisabled: function _setAddButtonDisabled(disabled) {
            this._$addButton.toggleClass('disabled', disabled).prop('disabled', disabled);
        },
        _onClickAdd: function _onClickAdd(e) {
            e.preventDefault();
            this._addSelected();
        },
        _onSelectPermission: function _onSelectPermission(e) {
            e.preventDefault();
            var $anchor = (0, _jquery2.default)(e.target);
            this._permission = $anchor.closest('li').attr('data-value');
            this.$el.find('.permission-type-trigger').text($anchor.text());
        },
        _onChangeEntitySelection: function _onChangeEntitySelection() {
            this._setAddButtonDisabled(!this.getSelected().length);
        }
    });

    exports.default = PermissionMultiSelector;
    module.exports = exports['default'];
});