define('bitbucket/internal/feature/pull-request/list/pull-request-list-analytics', ['module', 'exports', 'jquery', 'lodash', 'bitbucket/internal/util/analytics', 'bitbucket/util/state'], function (module, exports, _jquery, _lodash, _analytics, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var analytics = _interopRequireWildcard(_analytics);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var REPOSITORY_ID = _state2.default.getRepository().id;
    var CURRENT_USER_NAME = _state2.default.getCurrentUser().name;

    function initButtonAnalytics(createAction) {
        var $createAction = (0, _jquery2.default)(createAction);

        $createAction.on('click', function () {
            analytics.add('stash.client.pullRequestList.createAction.clicked', {
                'repository.id': REPOSITORY_ID
            });
        });
    }

    var filterState = void 0;

    /**
     * triggered when the filter has changed.
     * Works out which of the properties has changed by comparing to a stored filter state and
     * triggers the appropriate analytics events.
     * @param {Object} filter - the new filter state
     */
    function onFilterChanged(filter) {
        if (!_lodash2.default.isObject(filterState)) {
            filterState = filter;
        }

        // State Filter changed
        if (filter.state && filterState.state !== filter.state) {
            analytics.add('stash.client.pullRequestList.filteredBy.state', {
                'repository.id': REPOSITORY_ID,
                state: filter.state
            });
        }

        // Author Filter changed
        if (filter.author_id && filterState.author_id !== filter.author_id) {
            analytics.add('stash.client.pullRequestList.filteredBy.author', {
                'repository.id': REPOSITORY_ID,
                'author.is.self': filter.author_id === CURRENT_USER_NAME
            });
        }
        // Target branch Filter changed
        if (filter.target_ref_id && filterState.target_ref_id !== filter.target_ref_id) {
            analytics.add('stash.client.pullRequestList.filteredBy.target', {
                'repository.id': REPOSITORY_ID
            });
        }

        // Reviewer Filter changed
        if (filter.reviewer_id && filterState.reviewer_id !== filter.reviewer_id) {
            analytics.add('stash.client.pullRequestList.filteredBy.reviewer', {
                'repository.id': REPOSITORY_ID,
                'reviewer.is.self': filter.reviewer_id === CURRENT_USER_NAME
            });
        }

        // Search query Filter changed
        if (filter.filterText && filterState.filterText !== filter.filterText) {
            analytics.add('stash.client.pullRequestList.filteredBy.searchQuery', {
                'repository.id': REPOSITORY_ID,
                'searchQuery.length': filter.filterText.length
            });
        }

        filterState = filter;
    }

    function initBuildStatusAnalytics() {
        var validBuildStatus = ['SUCCESSFUL', 'FAILED', 'INPROGRESS', 'CANCELLED', 'UNKNOWN', 'NONE'];

        (0, _jquery2.default)(document).on('click', '.pull-requests-table .build-status-pr-list-col-value .build-icon', function () {
            var $el = (0, _jquery2.default)(this);
            var status = $el.attr('data-build-status');

            if (_lodash2.default.includes(validBuildStatus, status)) {
                var prId = $el.closest('tr').attr('data-pull-request-id');

                analytics.add('stash.client.pullRequestList.buildStatus.clicked', {
                    'build.status': status,
                    'pullRequest.id': prId,
                    'repository.id': REPOSITORY_ID
                });
            }
        });
    }

    function initEmptyStateAnalytics() {
        // Create new PR clicked from getting started page
        (0, _jquery2.default)(document).on('click', '#empty-list-create-pr-button', function () {
            analytics.add('stash.client.pullRequestList.empty.create.clicked', {
                'repository.id': REPOSITORY_ID,
                page: 'pull-request-intro'
            });
        });

        // Create new PR clicked from no open PRs page
        (0, _jquery2.default)(document).on('click', '#empty-list-create-new-pull-request-button', function () {
            analytics.add('stash.client.pullRequestList.empty.create.clicked', {
                'repository.id': REPOSITORY_ID,
                page: 'no-open-prs'
            });
        });

        // Learn more clicked from getting started page
        (0, _jquery2.default)(document).on('click', '#empty-list-help-button', function () {
            analytics.add('stash.client.pullRequestList.empty.help.clicked', {
                'repository.id': REPOSITORY_ID,
                page: 'pull-request-intro'
            });
        });

        // View open PRs clicked from no open PRs page
        (0, _jquery2.default)(document).on('click', '#reset-filters', function () {
            analytics.add('stash.client.pullRequestList.empty.viewOpen.clicked', {
                'repository.id': REPOSITORY_ID,
                page: 'no-filtered-prs'
            });
        });
    }

    function initPullRequestRowAnalytics() {
        var initStarted = performance.now();

        (0, _jquery2.default)(document).on('click', '.pull-requests-table .pull-request-title', function () {
            var $row = (0, _jquery2.default)(this).closest('tr');
            var $summary = $row.find('.summary');
            var isDraft = $summary.attr('data-is-draft') === 'true';
            var prId = $summary.attr('data-pull-request-id');
            var prAuthor = $summary.attr('data-username');
            var isReviewer = $row.find('.reviewers .user-avatar').filter(function (i, avatar) {
                return (0, _jquery2.default)(avatar).data('username') === CURRENT_USER_NAME;
            }).length > 0;

            var buildStatus = $row.find('.build-status-pr-list-col-value .build-icon').attr('data-build-status');

            analytics.add('stash.client.pullRequestList.row.clicked', {
                'author.is.self': prAuthor === CURRENT_USER_NAME,
                'build.status': buildStatus,
                'pullRequest.id': prId,
                'pullRequest.properties.draft': isDraft,
                'repository.id': REPOSITORY_ID,
                'reviewer.is.self': isReviewer,
                'time.since.page.loaded': Math.round(performance.now() - initStarted)
            });
        });
    }

    /**
     * Trigger a ui pagination event for the pull request list
     * @param {Object} e - event data
     * @param {number} e.page
     */
    function onPaginate(e) {
        analytics.add('stash.client.nav.pagination', {
            context: 'pull-request-list',
            page: e.page
        });
    }

    /**
     * @param {Object} options
     * @param {Object} options.filterParams - the filter params
     */
    function init(options) {
        var $createAction = (0, _jquery2.default)('#list-create-pr-button');
        filterState = options.filterParams;
        initButtonAnalytics($createAction);
        initBuildStatusAnalytics();
        initEmptyStateAnalytics();
        initPullRequestRowAnalytics();

        analytics.add('stash.client.pullRequestList.viewed', {
            'author.is.self': options.filterParams.author_id === CURRENT_USER_NAME,
            'filtered.by.author': Boolean(options.filterParams.author_id),
            'filtered.by.reviewer': Boolean(options.filterParams.reviewer_id),
            'filtered.by.target': Boolean(options.filterParams.target_ref_id),
            'filtered.by.searchQuery': Boolean(options.filterParams.filterText),
            'repository.id': REPOSITORY_ID,
            'reviewer.is.self': options.filterParams.reviewer_id === CURRENT_USER_NAME,
            'searchQuery.length': options.filterParams.filterText ? options.filterParams.filterText.length : 0
        });
    }

    exports.default = {
        init: init,
        onFilterChanged: onFilterChanged,
        onPaginate: onPaginate
    };
    module.exports = exports['default'];
});