define('bitbucket/internal/feature/pull-request/reviewer-groups/reviewer-groups', ['module', 'exports', '@atlassian/aui', 'jquery', 'lodash', 'bitbucket/internal/enums', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/events', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state'], function (module, exports, _aui, _jquery, _lodash, _enums, _analytics, _events, _navbuilder, _server, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var analytics = _interopRequireWildcard(_analytics);

    var _events2 = _interopRequireDefault(_events);

    var nav = _interopRequireWildcard(_navbuilder);

    var server = _interopRequireWildcard(_server);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var ERROR_ID = 'reviewer-groups-error';

    var addReviewerGroupMembers = function addReviewerGroupMembers(group) {
        var currentUser = _state2.default.getCurrentUser();

        var $reviewerEl = (0, _jquery2.default)('#reviewers');

        // get existing reviewers list and remove group item from list
        var currentReviewers = $reviewerEl.data('select2').data().filter(function (reviewer) {
            return reviewer.id !== group.id;
        });

        currentReviewers = _lodash2.default.sortBy(currentReviewers, 'name');

        server.rest({
            url: nav.rest().repository(_state2.default.getRepository()).addPathComponents('settings', 'reviewer-groups', group.item.id, 'users').withParams({ avatarSize: _enums.AvatarSize.DEFAULT }).build()
        }).done(function (users) {
            if (_lodash2.default.isEmpty(users)) {
                var escapedGroupName = (0, _aui.escapeHtml)(group.id);

                (0, _aui.flag)({
                    type: 'error',
                    close: 'auto',
                    title: _aui.I18n.getText('bitbucket.web.pullrequest.group.reviewers.add.group.members.no.permission.title'),
                    body: _aui.I18n.getText('bitbucket.web.pullrequest.group.reviewers.add.group.members.no.permission.description.html', escapedGroupName)
                });
            } else {
                var _currentReviewers;

                var newReviewers = [];

                users.forEach(function (user) {
                    var reviewerToOption = {
                        id: user.name,
                        item: user
                    };

                    var existingReviewer = currentReviewers.find(function (reviewer) {
                        return reviewer.item.id === user.id;
                    });
                    var isCurrentUser = user.id === currentUser.id;

                    // filter out existing reviewers or current user from list
                    if (!existingReviewer && !isCurrentUser) {
                        newReviewers.push(reviewerToOption);
                    }
                });

                if (_lodash2.default.isEmpty(newReviewers)) {
                    (0, _aui.flag)({
                        type: 'info',
                        close: 'auto',
                        title: _aui.I18n.getText('bitbucket.web.pullrequest.group.reviewers.add.group.members.already.present.title'),
                        body: _aui.I18n.getText('bitbucket.web.pullrequest.group.reviewers.add.group.members.already.present.description')
                    });
                }

                (_currentReviewers = currentReviewers).push.apply(_currentReviewers, newReviewers);
            }

            // update reviewer list
            $reviewerEl.data('select2').data(currentReviewers);
        }).fail(function () {
            // update reviewer list without group item
            $reviewerEl.data('select2').data(currentReviewers);
        });
    };

    function onReady() {
        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.searchable.multi.selector/change', function (change) {
            var REPOSITORY_ID = _state2.default.getRepository().id;
            (0, _jquery2.default)('#' + ERROR_ID).remove();

            // TODO: BBSDEV-23263 change this when we have a proper server response
            var changeType = _lodash2.default.get(change, 'item.type');

            if (changeType === 'REVIEWER_GROUP') {
                analytics.add('pullRequest.reviewer.group.added', {
                    'repository.id': REPOSITORY_ID
                });

                addReviewerGroupMembers(change);
            }

            if (changeType === 'NORMAL') {
                analytics.add('pullRequest.reviewer.user.added', {
                    'repository.id': REPOSITORY_ID
                });
            }
        });
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});