define('bitbucket/internal/feature/pull-request/state-lozenge', ['module', 'exports', '@atlassian/aui', 'classnames', 'prop-types', 'react', 'bitbucket/internal/enums', 'bitbucket/internal/util/time'], function (module, exports, _aui, _classnames, _propTypes, _react, _enums, _time) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _customMapping, _pullRequestStateTitl, _lozengeTypeMap;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var propTypes = {
        pullRequest: _propTypes2.default.object.isRequired
    };

    var customMapping = (_customMapping = {}, _defineProperty(_customMapping, _enums.PullRequestState.DECLINED, {
        aMomentAgo: function aMomentAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.a.moment.ago');
        },
        oneMinuteAgo: function oneMinuteAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.one.minute.ago');
        },
        xMinutesAgo: function xMinutesAgo(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.x.minutes.ago', param);
        },
        oneHourAgo: function oneHourAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.one.hour.ago');
        },
        xHoursAgo: function xHoursAgo(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.x.hours.ago', param);
        },
        oneDayAgo: function oneDayAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.one.day.ago');
        },
        xDaysAgo: function xDaysAgo(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.x.days.ago', param);
        },
        oneWeekAgo: function oneWeekAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.one.week.ago');
        },
        absolute: function absolute(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.absolute', param);
        }
    }), _defineProperty(_customMapping, _enums.PullRequestState.MERGED, {
        aMomentAgo: function aMomentAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.a.moment.ago');
        },
        oneMinuteAgo: function oneMinuteAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.one.minute.ago');
        },
        xMinutesAgo: function xMinutesAgo(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.x.minutes.ago', param);
        },
        oneHourAgo: function oneHourAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.one.hour.ago');
        },
        xHoursAgo: function xHoursAgo(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.x.hours.ago', param);
        },
        oneDayAgo: function oneDayAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.one.day.ago');
        },
        xDaysAgo: function xDaysAgo(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.x.days.ago', param);
        },
        oneWeekAgo: function oneWeekAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.one.week.ago');
        },
        absolute: function absolute(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.absolute', param);
        }
    }), _customMapping);

    var pullRequestStateTitleMap = (_pullRequestStateTitl = {}, _defineProperty(_pullRequestStateTitl, _enums.PullRequestState.OPEN, _aui.I18n.getText('bitbucket.component.pull.request.list.state.open')), _defineProperty(_pullRequestStateTitl, _enums.PullRequestState.DECLINED, _aui.I18n.getText('bitbucket.component.pull.request.list.state.declined')), _defineProperty(_pullRequestStateTitl, _enums.PullRequestState.MERGED, _aui.I18n.getText('bitbucket.component.pull.request.list.state.merged')), _pullRequestStateTitl);

    var lozengeTypeMap = (_lozengeTypeMap = {}, _defineProperty(_lozengeTypeMap, _enums.PullRequestState.OPEN, 'current'), _defineProperty(_lozengeTypeMap, _enums.PullRequestState.MERGED, 'success'), _defineProperty(_lozengeTypeMap, _enums.PullRequestState.DECLINED, 'error'), _lozengeTypeMap);

    var StateLozenge = function StateLozenge(_ref) {
        var pullRequest = _ref.pullRequest,
            className = _ref.className,
            _ref$subtle = _ref.subtle,
            subtle = _ref$subtle === undefined ? false : _ref$subtle;
        return _react2.default.createElement(
            'span',
            {
                className: (0, _classnames2.default)(className, 'aui-lozenge', 'aui-lozenge-' + lozengeTypeMap[[pullRequest.state]], { 'aui-lozenge-subtle': subtle }),
                title: (0, _time.format)(pullRequest.closedDate, 'shortAge', customMapping[pullRequest.state])
            },
            pullRequestStateTitleMap[pullRequest.state]
        );
    };

    StateLozenge.propTypes = propTypes;

    exports.default = StateLozenge;
    module.exports = exports['default'];
});