define('bitbucket/internal/feature/repository/branch-table-pull-requests/branch-table-pull-requests', ['module', 'exports', 'jquery', 'bitbucket/internal/feature/pull-request/list-dialog/pull-request-list-dialog', 'bitbucket/internal/util/dom-event', 'bitbucket/util/navbuilder', 'bitbucket/util/state'], function (module, exports, _jquery, _pullRequestListDialog, _domEvent, _navbuilder, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var PullRequestDialog = _interopRequireWildcard(_pullRequestListDialog);

    var _domEvent2 = _interopRequireDefault(_domEvent);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function onReady() {
        PullRequestDialog.listenForNavigationKeyboardShortcuts();

        (0, _jquery2.default)('.branch-list-panel').on('click', '.pull-request-list-trigger', function (e) {
            if (e.target.tagName === 'A' && !_domEvent2.default.openInSameTab(e)) {
                // The user is attempting to open the PR in a separate tab/window.
                // Let the browser handle the click event natively
                return;
            }

            e.preventDefault();

            var branchId = (0, _jquery2.default)(this).closest('[data-branch-id]').attr('data-branch-id');

            var navBuilder = nav.rest().repository(_state2.default.getRepository()).allPullRequests().withParams({
                at: branchId,
                direction: 'outgoing',
                order: 'newest',
                state: 'ALL'
            });

            PullRequestDialog.showFor(navBuilder);
        });

        (0, _jquery2.default)(document).tooltip({
            gravity: 'n',
            live: '.pull-request-list-trigger'
        });
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});