define('bitbucket/internal/feature/repository/branch-table/branch-table', ['module', 'exports', '@atlassian/aui', 'jquery', 'lodash', 'bitbucket/internal/model/page-state', 'bitbucket/internal/util/events', 'bitbucket/internal/widget/keyboard-controller', 'bitbucket/internal/widget/paged-table/paged-table', 'bitbucket/util/navbuilder', 'bitbucket/util/state'], function (module, exports, _aui, _jquery, _lodash, _pageState, _events, _keyboardController, _pagedTable, _navbuilder, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _pageState2 = _interopRequireDefault(_pageState);

    var _events2 = _interopRequireDefault(_events);

    var keyboardController = _interopRequireWildcard(_keyboardController);

    var _pagedTable2 = _interopRequireDefault(_pagedTable);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var ListKeyboardController = keyboardController.ListKeyboardController;

    function validateRef(ref) {
        if (!ref) {
            throw new Error('Undefined ref');
        } else if (!ref.id) {
            throw new Error('Ref without id');
        }

        return ref;
    }

    function BranchTable(options, baseRef) {
        _pagedTable2.default.call(this, _jquery2.default.extend({}, BranchTable.defaults, options));
        this._baseRef = validateRef(baseRef);
        this.rowSelector = 'tr.branch-row';
        this.focusedRowSelector = this.rowSelector + '.' + this.options.focusOptions.focusedClass;
    }

    BranchTable.defaults = {
        filterable: true,
        pageSize: 20, // this must be less than ref.metadata.max.request.count
        noneFoundMessageHtml: AJS.escapeHtml(AJS.I18n.getText('bitbucket.web.repository.branch.table.no.branches')),
        noneMatchingMessageHtml: AJS.escapeHtml(AJS.I18n.getText('bitbucket.web.repository.branch.table.no.matches')),
        idForEntity: function idForEntity(ref) {
            return ref.id;
        },
        paginationContext: 'branch-table'
    };

    _jquery2.default.extend(BranchTable.prototype, _pagedTable2.default.prototype);

    BranchTable.prototype.buildUrl = function (start, limit, filter) {
        // Ideally the context would be populated from a plugin (in this case the branch plugin)
        // but we do not expose a JS API for it yet
        var context = JSON.stringify({ withMessages: false });
        var params = {
            base: this._baseRef.id,
            details: true,
            start: start,
            limit: limit,
            orderBy: 'MODIFICATION', // Always order by last modified regardless of filtering
            context: context
        };

        if (filter) {
            params.filterText = filter;
        }

        return nav.rest().repository(_state2.default.getRepository()).branches().withParams(params).build();
    };

    BranchTable.prototype.handleNewRows = function (branchPage, attachmentMethod) {
        this.$table.find('tbody')[attachmentMethod](bitbucket.internal.feature.repository.branchTable.branchTable.branchRows({
            branches: branchPage.values,
            baseRef: this._baseRef,
            repository: _pageState2.default.getRepository().toJSON()
        }));
    };

    BranchTable.prototype.isCurrentBase = function (ref) {
        return this._baseRef.id === validateRef(ref).id;
    };

    BranchTable.prototype.update = function (baseRef, options) {
        if (baseRef) {
            this._baseRef = validateRef(baseRef);
        }
        _pagedTable2.default.prototype.update.call(this, options);
    };

    BranchTable.prototype.remove = function (ref) {
        if (_pagedTable2.default.prototype.remove.call(this, ref)) {
            var $row = this.$table.find('tbody > tr[data-id="' + ref.id + '"]');
            $row.fadeOut(_lodash2.default.bind(function () {
                if ($row.hasClass('focused')) {
                    var $nextRow = $row.next();
                    var $nextFocus = $nextRow.length ? $nextRow : $row.prev();

                    if ($nextFocus.length) {
                        $nextFocus.addClass('focused');
                        $nextFocus.find('td[headers=branch-name-column] > a').focus();
                    }
                }
                $row.remove();

                // Ensure we display the no data message when
                // the last row is deleted
                if (this.loadedRange.reachedStart() && this.loadedRange.reachedEnd() && !this.$table.find('tbody > tr').length) {
                    this.handleNoData();
                }

                this.updateTimestamp();
            }, this));

            return true;
        }

        return false;
    };

    BranchTable.prototype.focusInitialRow = function () {
        this.$table.find(this.rowSelector).first().addClass(this.options.focusOptions.focusedClass);
    };

    BranchTable.prototype._bindKeyboardNavigation = function () {
        var options = this.options.focusOptions;
        var focusedRowSelector = this.focusedRowSelector;
        this._filesKeyboardController = new ListKeyboardController(this.$filter, (0, _jquery2.default)(this.$table.selector), {
            wrapAround: false,
            focusedClass: options.focusedClass,
            itemSelector: this.rowSelector,
            onSelect: function onSelect(focusedRowSelector) {
                openItem(focusedRowSelector);
            }
        });
    };

    function openItem(focusedRowSelector) {
        var $focusedItem = (0, _jquery2.default)(focusedRowSelector);

        if ($focusedItem.length) {
            location.href = $focusedItem.find('td[headers=branch-name-column] a').attr('href');
        }
    }

    BranchTable.prototype.initShortcuts = function () {
        _pagedTable2.default.prototype.initShortcuts.call(this);

        var options = this.options.focusOptions;
        var rowSelector = this.rowSelector;
        var focusedRowSelector = this.focusedRowSelector;
        this._bindKeyboardNavigation();

        _events2.default.on('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.requestMoveToNextHandler', function (keys) {
            (this.moveToNextItem ? this : AJS.whenIType(keys)).moveToNextItem(rowSelector, options).execute(function () {
                if ((0, _jquery2.default)(rowSelector).last().hasClass(options.focusedClass)) {
                    window.scrollTo(0, document.documentElement.scrollHeight);
                }
            });
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.requestMoveToPreviousHandler', function (keys) {
            (this.moveToPrevItem ? this : AJS.whenIType(keys)).moveToPrevItem(rowSelector, options);
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.requestOpenItemHandler', function (keys) {
            (this.execute ? this : AJS.whenIType(keys)).execute(function () {
                openItem(focusedRowSelector);
            });
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.requestOpenItemActionHandler', function (keys) {
            (this.execute ? this : AJS.whenIType(keys)).execute(function () {
                var $focusedItem = (0, _jquery2.default)(focusedRowSelector);

                if ($focusedItem.length) {
                    $focusedItem.find('.branch-list-action-trigger').click();
                }
            });
        });
    };

    exports.default = BranchTable;
    module.exports = exports['default'];
});