define('bitbucket/internal/feature/repository/filterable-repository-table/filterable-repository-table', ['exports', '@atlassian/aui', 'classnames', 'lodash', 'prop-types', 'react', 'bitbucket/internal/bbui/aui-react/avatar', 'bitbucket/internal/enums', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/feature-enabled', 'bitbucket/internal/util/highlight', 'bitbucket/internal/widget/filterable-entity-table/filterable-entity-table', 'bitbucket/internal/widget/icons/icons', 'bitbucket/util/navbuilder'], function (exports, _aui, _classnames, _lodash, _propTypes, _react, _avatar, _enums, _analytics, _featureEnabled, _highlight, _filterableEntityTable, _icons, _navbuilder) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.RepositoryRow = undefined;
    exports.filterFromUrlParams = filterFromUrlParams;
    exports.updateUrlWithFilterParams = updateUrlWithFilterParams;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var analytics = _interopRequireWildcard(_analytics);

    var _highlight2 = _interopRequireDefault(_highlight);

    var _filterableEntityTable2 = _interopRequireDefault(_filterableEntityTable);

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    /**
     * Add a set of params to a given URL
     * @param {string} url
     * @param {Object<string, string>} params
     * @returns {string}
     */
    function urlWithParams(url, params) {
        var uri = nav.parse(url);
        Object.keys(params).forEach(function (k) {
            if (params[k]) {
                uri.replaceQueryParam(k, params[k]);
            } else {
                // delete params that are empty
                uri.deleteQueryParam(k);
            }
        });

        return uri.toString();
    }

    /**
     * Get a filter object from the URL params
     * @returns {Object<string, string>}
     */
    function filterFromUrlParams(queryParamByFilterKey) {
        var params = {};
        var uri = nav.parse(window.location);

        // get the query params for each of the items in the filter map
        _lodash2.default.values(queryParamByFilterKey).forEach(function (key) {
            var val = uri.getQueryParamValue(key);

            if (val) {
                params[key] = val;
            }
        });
        var filterKeyByQueryParam = _lodash2.default.invert(queryParamByFilterKey);

        return _lodash2.default.mapKeys(params, function (v, k) {
            return filterKeyByQueryParam[k] || k;
        });
    }

    /**
     * Update the URL with the appropriate params based on given filter
     * @param {Object} filter
     */
    function updateUrlWithFilterParams(queryParamByFilterKey, filter) {
        var mappedFilterParams = _lodash2.default.mapKeys(filter, function (v, k) {
            return queryParamByFilterKey[k] || k;
        });
        history.replaceState(mappedFilterParams, null, urlWithParams(window.location, mappedFilterParams));
    }

    var isPublicAccessFeatureEnabled = (0, _featureEnabled.getFromProviderSync)('public.access');

    var ProjectWithAvatar = function ProjectWithAvatar(_ref) {
        var filter = _ref.filter,
            onClick = _ref.onClick,
            project = _ref.project;

        var isNormalProject = project.type === _enums.ProjectType.NORMAL;

        return _react2.default.createElement(
            'span',
            { className: 'project-name' },
            _react2.default.createElement(_avatar.Avatar, {
                alt: project.name,
                avatarSrc: project.avatarUrl,
                size: _enums.AvatarTShirtSize.SMALL,
                isProject: isNormalProject
            }),
            _react2.default.createElement(
                'a',
                {
                    className: 'aui-button aui-button-link',
                    href: nav.project(project).build(),
                    onClick: onClick ? function () {
                        return onClick(project);
                    } : null
                },
                _react2.default.createElement(_highlight2.default, { text: project.name, query: filter })
            )
        );
    };

    var RepositoryIcon = function RepositoryIcon(_ref2) {
        var origin = _ref2.origin,
            archived = _ref2.archived;

        if (archived) {
            return _react2.default.createElement(_icons.ArchiveIcon, { className: 'repository-icon' });
        }
        if (origin) {
            return _react2.default.createElement(
                _icons.ForkSmallIcon,
                {
                    className: 'repository-icon',
                    title: _aui.I18n.getText('bitbucket.web.repository.is.a.fork.of', origin.project.name, origin.name)
                },
                _aui.I18n.getText('bitbucket.web.repository.repository.forked')
            );
        }

        return _react2.default.createElement(
            _icons.RepositorySmallIcon,
            { className: 'repository-icon' },
            _aui.I18n.getText('bitbucket.web.repository.repository')
        );
    };

    var PublicLozenge = function PublicLozenge() {
        return _react2.default.createElement(
            'span',
            { className: 'aui-lozenge aui-lozenge-subtle public-lozenge' },
            _aui.I18n.getText('bitbucket.web.repository.public.lozenge')
        );
    };

    var ArchivedLozenge = function ArchivedLozenge() {
        return _react2.default.createElement(
            'span',
            { className: 'aui-lozenge aui-lozenge-subtle aui-lozenge-inprogress public-lozenge' },
            _aui.I18n.getText('bitbucket.web.repository.archived.lozenge')
        );
    };

    /*eslint-disable react/prefer-stateless-function*/

    var RepositoryRow = exports.RepositoryRow = function (_PureComponent) {
        _inherits(RepositoryRow, _PureComponent);

        function RepositoryRow() {
            _classCallCheck(this, RepositoryRow);

            return _possibleConstructorReturn(this, (RepositoryRow.__proto__ || Object.getPrototypeOf(RepositoryRow)).apply(this, arguments));
        }

        _createClass(RepositoryRow, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    filter = _props.filter,
                    focused = _props.focused,
                    onProjectClick = _props.onProjectClick,
                    onRepoClick = _props.onRepoClick,
                    primaryRefCallback = _props.primaryRefCallback,
                    repository = _props.repository,
                    showArchivedLozenge = _props.showArchivedLozenge,
                    showProject = _props.showProject,
                    showPublic = _props.showPublic;


                return _react2.default.createElement(
                    'tr',
                    { className: (0, _classnames2.default)({ focused: focused }) },
                    _react2.default.createElement(
                        'td',
                        { className: 'name-col' },
                        showProject ? _react2.default.createElement(ProjectWithAvatar, {
                            filter: filter,
                            project: repository.project,
                            onClick: onProjectClick
                        }) : _react2.default.createElement(RepositoryIcon, repository),
                        _react2.default.createElement(
                            'span',
                            { className: 'repository-name' },
                            _react2.default.createElement(
                                'a',
                                {
                                    className: 'aui-button aui-button-link',
                                    href: nav.project(repository.project).repo(repository).build(),
                                    onClick: onRepoClick ? function () {
                                        return onRepoClick(repository);
                                    } : null,
                                    ref: function ref(el) {
                                        return primaryRefCallback ? primaryRefCallback(el) : null;
                                    }
                                },
                                _react2.default.createElement(_highlight2.default, { text: repository.name, query: filter })
                            )
                        ),
                        isPublicAccessFeatureEnabled && showPublic && (repository.public || repository.project.public) && _react2.default.createElement(PublicLozenge, null),
                        showArchivedLozenge && repository.archived && _react2.default.createElement(ArchivedLozenge, null),
                        repository.state === 'OFFLINE' && _react2.default.createElement(
                            'span',
                            { className: 'aui-lozenge aui-lozenge-subtle offline-lozenge' },
                            _aui.I18n.getText('bitbucket.web.repository.list.repository.offline')
                        )
                    ),
                    _react2.default.createElement(
                        'td',
                        { className: 'description-col' },
                        _react2.default.createElement(
                            'p',
                            { className: 'repository-description', title: repository.description },
                            repository.description
                        )
                    )
                );
            }
        }]);

        return RepositoryRow;
    }(_react.PureComponent);

    RepositoryRow.propTypes = {
        focused: _propTypes2.default.bool,
        onProjectClick: _propTypes2.default.func,
        onRepoClick: _propTypes2.default.func,
        primaryRefCallback: _propTypes2.default.func,
        repository: _propTypes2.default.object,
        showArchivedLozenge: _propTypes2.default.bool,
        showProject: _propTypes2.default.bool,
        showPublic: _propTypes2.default.bool
    };
    RepositoryRow.defaultProps = {
        showProject: false,
        showPublic: true
    };

    var FilterableRepositoryTable = function (_FilterableEntityTabl) {
        _inherits(FilterableRepositoryTable, _FilterableEntityTabl);

        function FilterableRepositoryTable() {
            var _ref3;

            var _temp, _this2, _ret;

            _classCallCheck(this, FilterableRepositoryTable);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this2 = _possibleConstructorReturn(this, (_ref3 = FilterableRepositoryTable.__proto__ || Object.getPrototypeOf(FilterableRepositoryTable)).call.apply(_ref3, [this].concat(args))), _this2), _this2.onProjectClick = function (project) {
                var _this2$props = _this2.props,
                    filter = _this2$props.filter,
                    onProjectClick = _this2$props.onProjectClick;


                onProjectClick && onProjectClick(project, filter);
            }, _this2.onRepoClick = function (repository) {
                var _this2$props2 = _this2.props,
                    entities = _this2$props2.entities,
                    filter = _this2$props2.filter,
                    onRepoClick = _this2$props2.onRepoClick;


                onRepoClick && onRepoClick(repository, filter, entities);

                //Legacy event, avoid using
                analytics.add('repository-list.item.clicked', {
                    'repository.id': repository.id,
                    'project.id': repository.project.id
                });
            }, _this2.row = function (_ref4) {
                var repository = _ref4.item,
                    focused = _ref4.focused,
                    primaryRefCallback = _ref4.primaryRefCallback;
                return _react2.default.createElement(RepositoryRow, {
                    filter: _this2.props.filter,
                    focused: focused,
                    key: repository.id,
                    onProjectClick: _this2.onProjectClick,
                    onRepoClick: _this2.onRepoClick,
                    repository: repository,
                    showProject: _this2.props.showProject,
                    showPublic: _this2.props.showPublic,
                    primaryRefCallback: primaryRefCallback,
                    showArchivedLozenge: _this2.props.showArchivedLozenge
                });
            }, _temp), _possibleConstructorReturn(_this2, _ret);
        }

        return FilterableRepositoryTable;
    }(_filterableEntityTable2.default);

    FilterableRepositoryTable.propTypes = _extends({}, _filterableEntityTable2.default.propTypes, {
        onProjectClick: _propTypes2.default.func,
        onRepoClick: _propTypes2.default.func,
        showArchivedLozenge: _propTypes2.default.bool,
        showProject: _propTypes2.default.bool,
        showPublic: _propTypes2.default.bool
    });
    FilterableRepositoryTable.defaultProps = _extends({}, _filterableEntityTable2.default.defaultProps, {
        className: 'filterable-repository-table',
        header: _react2.default.createElement(
            'tr',
            null,
            _react2.default.createElement(
                'th',
                null,
                _aui.I18n.getText('bitbucket.web.repository.col.name')
            ),
            _react2.default.createElement(
                'th',
                null,
                _aui.I18n.getText('bitbucket.web.repository.col.description')
            )
        ),
        lastPageMessage: _aui.I18n.getText('bitbucket.web.repository.allfetched'),
        loadMoreMessage: _aui.I18n.getText('bitbucket.web.repository.loadmore'),
        noItemsMessage: _aui.I18n.getText('bitbucket.web.repository.nonefound'),
        showArchivedLozenge: false,
        showProject: false,
        showPublic: true,
        filterPlaceholder: _aui.I18n.getText('bitbucket.web.repository.filter.placeholder'),
        selectFilterProps: {
            id: 'repository-type-filter',
            label: _aui.I18n.getText('bitbucket.web.repository.filter.select.label'),
            value: _enums.RepositoryType.ACTIVE,
            items: [{
                id: _enums.RepositoryType.ACTIVE,
                text: _aui.I18n.getText('bitbucket.web.repository.filter.select.option.active')
            }, {
                id: _enums.RepositoryType.ARCHIVED,
                text: _aui.I18n.getText('bitbucket.web.repository.filter.select.option.archived')
            }, {
                id: _enums.RepositoryType.ALL,
                text: _aui.I18n.getText('bitbucket.web.repository.filter.select.option.all')
            }]
        },
        emptyStateWithFilterProps: {
            title: _aui.I18n.getText('bitbucket.web.repository.filter.table.empty.heading'),
            description: _aui.I18n.getText('bitbucket.web.repository.filter.table.empty.description')
        }
    });
    exports.default = FilterableRepositoryTable;
});