define('bitbucket/internal/feature/repository/search-results/search-results-list', ['module', 'exports', 'prop-types', 'react', 'wrm/i18n', './search-results-item'], function (module, exports, _propTypes, _react, _i18n, _searchResultsItem) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _searchResultsItem2 = _interopRequireDefault(_searchResultsItem);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var SearchResultsList = function (_Component) {
        _inherits(SearchResultsList, _Component);

        function SearchResultsList() {
            _classCallCheck(this, SearchResultsList);

            return _possibleConstructorReturn(this, (SearchResultsList.__proto__ || Object.getPrototypeOf(SearchResultsList)).apply(this, arguments));
        }

        _createClass(SearchResultsList, [{
            key: 'shouldComponentUpdate',
            value: function shouldComponentUpdate(nextProps) {
                return nextProps.query !== this.props.query || // the query has changed, so the results will be different
                nextProps.repositories !== this.props.repositories // the total number of repos has changed (clicked "load more")
                ;
            }
        }, {
            key: 'renderListWrapper',
            value: function renderListWrapper(repositories, onItemClick) {
                var _this2 = this;

                return _react2.default.createElement(
                    'ul',
                    { className: 'repository-list search-results-container' },
                    repositories.map(function (repo, index) {
                        return _react2.default.createElement(_searchResultsItem2.default, {
                            key: repo.id,
                            repository: repo,
                            onItemClick: onItemClick,
                            query: _this2.props.query
                        });
                    })
                );
            }
        }, {
            key: 'render',
            value: function render() {
                var _props = this.props,
                    EmptyState = _props.EmptyState,
                    LoadMore = _props.LoadMore,
                    onItemClick = _props.onItemClick,
                    repositories = _props.repositories,
                    title = _props.title;


                return _react2.default.createElement(
                    _react.Fragment,
                    null,
                    _react2.default.createElement(
                        'span',
                        { 'aria-hidden': 'true', className: 'aui-dropdown2-heading' },
                        _i18n.I18n.getText('bitbucket.web.menu.repositories.recentlyviewed')
                    ),
                    title,
                    repositories && repositories.length > 0 ? this.renderListWrapper(repositories, onItemClick) : EmptyState,
                    LoadMore
                );
            }
        }]);

        return SearchResultsList;
    }(_react.Component);

    SearchResultsList.propTypes = {
        repositories: _propTypes2.default.array,
        title: _propTypes2.default.node,
        onItemClick: _propTypes2.default.func,
        EmptyState: _propTypes2.default.element,
        LoadMore: _propTypes2.default.element,
        query: _propTypes2.default.string
    };
    exports.default = SearchResultsList;
    module.exports = exports['default'];
});