define('bitbucket/internal/feature/settings/hooks/action-creators/configure-hook', ['exports', '@atlassian/aui', 'lodash', 'bitbucket/internal/util/enforce-project-settings/util', 'bitbucket/internal/util/scope-type', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state', '../actions'], function (exports, _aui, _lodash, _util, _scopeType, _navbuilder, _server, _state, _actions) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.getLocksForHooksAndChecks = exports.updateLock = exports.saveHookConfiguration = exports.inheritHook = exports.enableHook = exports.editHook = exports.cancelEditHook = undefined;

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var makeAction = function makeAction(type, payload) {
        return { type: type, payload: payload };
    };

    var statusCode = {
        409: false,
        404: false,
        400: false,
        // show refresh button in error when restriction is present
        403: function _(xhr, testStatus, errorThrown, data) {
            var error = (0, _lodash.get)(data, 'errors.0');
            var message = error && error.message;

            return {
                title: _aui.I18n.getText('bitbucket.web.dialog.ajax.error.title'),
                message: message,
                shouldReload: true,
                fallbackUrl: undefined
            };
        }
    };

    var startEditHook = function startEditHook(currentScope, hook, dispatch) {
        dispatch(makeAction(_actions.EDIT_HOOK, { hook: hook }));

        var currentScopeMethod = (0, _scopeType.scopeNavAndStateMethod)(currentScope.type);
        var target = _state2.default[currentScopeMethod.state]();
        var navMethod = currentScopeMethod.nav;

        return (0, _server.rest)({
            url: nav.rest()[navMethod](target).hook(hook.details.key).settings().build(),
            statusCode: statusCode
        }).done(function (config) {
            return dispatch(makeAction(_actions.LOAD_HOOK_SETTINGS_SUCCESS, { hook: hook, config: config }));
        }).fail(function (xhr, textStatus, errorThrown, errors) {
            return dispatch(makeAction(_actions.LOAD_HOOK_SETTINGS_FAILURE, {
                hook: hook,
                error: (0, _lodash.get)(errors, 'errors.0.message', _aui.I18n.getText('bitbucket.web.hooks.settings.load.error', hook.details.name))
            }));
        });
    };

    var cancelEditHook = exports.cancelEditHook = function cancelEditHook(currentScope, hook) {
        return makeAction(_actions.EDIT_HOOK_CANCEL, { hook: hook });
    };

    var editHook = exports.editHook = function editHook(currentScope, hook) {
        return function (dispatch) {
            return startEditHook(currentScope, hook, dispatch);
        };
    };

    var enableHook = exports.enableHook = function enableHook(currentScope, hook, enable) {
        return function (dispatch) {
            dispatch(makeAction(_actions.ENABLE_HOOK, { hook: hook, enable: enable }));

            if (enable && hook.details.configFormKey) {
                return startEditHook(currentScope, hook, dispatch);
            }

            var currentScopeMethod = (0, _scopeType.scopeNavAndStateMethod)(currentScope.type);
            var target = _state2.default[currentScopeMethod.state]();
            var navMethod = currentScopeMethod.nav;

            return (0, _server.rest)({
                url: nav.rest()[navMethod](target).hook(hook.details.key).enabled().withParams({ enrich: true }).build(),
                type: enable ? _server.method.PUT : _server.method.DELETE,
                statusCode: statusCode
            }).done(function (updatedHook) {
                return dispatch(makeAction(_actions.ENABLE_HOOK_SUCCESS, { hook: updatedHook }));
            }).fail(function (xhr, textStatus, errorThrown, errors) {
                return dispatch(makeAction(_actions.ENABLE_HOOK_FAILURE, {
                    hook: hook,
                    enable: enable,
                    error: (0, _lodash.get)(errors, 'errors.0.message', enable ? _aui.I18n.getText('bitbucket.web.hooks.enable.error', hook.details.name) : _aui.I18n.getText('bitbucket.web.hooks.disable.error', hook.details.name))
                }));
            });
        };
    };

    var inheritHook = exports.inheritHook = function inheritHook(currentScope, hook) {
        return function (dispatch) {
            dispatch(makeAction(_actions.INHERIT_HOOK, { hook: hook }));

            var url = nav.rest().repository(_state2.default.getRepository()).hook(hook.details.key).withParams({ enrich: true }).build();

            return (0, _server.rest)({
                url: url,
                type: _server.method.DELETE,
                statusCode: statusCode
            }).fail(function (xhr, textStatus, errorThrown, errors) {
                return dispatch(makeAction(_actions.INHERIT_HOOK_FAILURE, {
                    hook: hook,
                    error: (0, _lodash.get)(errors, 'errors.0.message', _aui.I18n.getText('bitbucket.web.hooks.inherit.error', hook.details.name))
                }));
            }).then(function () {
                return (0, _server.rest)({ url: url });
            }).done(function (updatedHook) {
                return dispatch(makeAction(_actions.INHERIT_HOOK_SUCCESS, { hook: updatedHook }));
            });
        };
    };

    var saveHookConfiguration = exports.saveHookConfiguration = function saveHookConfiguration(currentScope, hook, config) {
        return function (dispatch) {
            dispatch(makeAction(_actions.SAVE_HOOK_SETTINGS, { hook: hook, config: config }));

            var currentScopeMethod = (0, _scopeType.scopeNavAndStateMethod)(currentScope.type);
            var target = _state2.default[currentScopeMethod.state]();
            var navMethod = currentScopeMethod.nav;

            //Always save to the `enabled` endpoint rather than the `settings` one as it handles both the edit and enable use-cases and returns the updated hook
            return (0, _server.rest)({
                url: nav.rest()[navMethod](target).hook(hook.details.key).enabled().withParams({ enrich: true }).build(),
                type: _server.method.PUT,
                data: config,
                statusCode: statusCode
            }).done(function (updatedHook) {
                return dispatch(makeAction(_actions.SAVE_HOOK_SETTINGS_SUCCESS, {
                    hook: updatedHook,
                    config: config
                }));
            }).fail(function (xhr, textStatus, errorThrown, _ref) {
                var errors = _ref.errors;
                return dispatch(makeAction(_actions.SAVE_HOOK_SETTINGS_FAILURE, { hook: hook, config: config, errors: errors }));
            });
        };
    };

    var updateLock = exports.updateLock = function updateLock(currentScope, hook, isLocked) {
        return function (dispatch) {
            // dispatch processing state
            dispatch(makeAction(_actions.UPDATE_LOCK_SUCCESS, {
                hook: _extends({}, hook, { restrictionState: _util.RestrictionProcessingStates.PROCESSING })
            }));

            return (0, _util.saveProjectLockSettings)({
                isLocked: isLocked,
                componentKey: hook.details.key,
                featureKey: _util.FeatureKeys.HOOKS,
                project: _state2.default.getProject()
            }).then(function (updatedLock) {
                // update local value
                dispatch(makeAction(_actions.UPDATE_LOCK_SUCCESS, {
                    hook: _extends({}, hook, {
                        restrictionState: updatedLock ? updatedLock.processedState : _util.RestrictionProcessingStates.NONE
                    })
                }));
            }).catch(function (xhr) {
                // if restriction is already present it will return 409
                if (xhr.status === 409) {
                    getLockDetails(currentScope, hook)(dispatch);
                }
            });
        };
    };

    var getLockDetails = function getLockDetails(currentScope, hook) {
        return function (dispatch) {
            return (0, _util.fetchRestriction)({
                componentKey: hook.details.key,
                featureKey: _util.FeatureKeys.HOOKS,
                project: _state2.default.getProject()
            }).then(function (updatedLock) {
                dispatch(makeAction(_actions.UPDATE_LOCK_SUCCESS, {
                    hook: _extends({}, hook, {
                        restrictionState: updatedLock ? updatedLock.processedState : _util.RestrictionProcessingStates.NONE
                    })
                }));
            }).catch(function (xhr) {
                // if there is no restriction it will return 404
                if (xhr.status === 404) {
                    dispatch(makeAction(_actions.UPDATE_LOCK_SUCCESS, {
                        hook: _extends({}, hook, {
                            restrictionState: _util.RestrictionProcessingStates.NONE
                        })
                    }));
                }
            });
        };
    };

    var getLocksForHooksAndChecks = exports.getLocksForHooksAndChecks = function getLocksForHooksAndChecks() {
        return function (dispatch) {
            // fetches lock details for both hooks and merge checks
            return (0, _util.fetchAllRestrictions)({
                featureKey: _util.FeatureKeys.HOOKS,
                project: _state2.default.getProject()
            }).then(function (updatedLocks) {
                dispatch(makeAction(_actions.UPDATE_LOCKS_RESTRICTION_STATE, updatedLocks.values));
            });
        };
    };
});