define('bitbucket/internal/feature/settings/hooks/action-creators/load-hooks', ['exports', 'bitbucket/internal/util/scope-type', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state', '../actions'], function (exports, _scopeType, _navbuilder, _server, _state, _actions) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.populateHooks = exports.DEFAULT_PAGE_SIZE = undefined;

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var DEFAULT_PAGE_SIZE = exports.DEFAULT_PAGE_SIZE = 25;

    function loadHooksSuccess(payload, type) {
        return {
            type: _actions.LOAD_HOOKS_SUCCESS,
            payload: payload,
            meta: { type: type }
        };
    }

    exports.default = function (currentScope, type) {
        var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
            _ref$start = _ref.start,
            start = _ref$start === undefined ? 0 : _ref$start,
            _ref$limit = _ref.limit,
            limit = _ref$limit === undefined ? DEFAULT_PAGE_SIZE : _ref$limit;

        return function (dispatch) {
            dispatch({
                type: _actions.LOAD_HOOKS,
                meta: { type: type }
            });

            var currentScopeMethod = (0, _scopeType.scopeNavAndStateMethod)(currentScope.type);
            var target = _state2.default[currentScopeMethod.state]();
            var navMethod = currentScopeMethod.nav;

            return (0, _server.rest)({
                url: nav.rest()[navMethod](target).hooks().withParams({ limit: limit, start: start, type: type, enrich: true }).build()
            }).done(function (data) {
                return dispatch(loadHooksSuccess(data, type));
            });
        };
    };

    var populateHooks = exports.populateHooks = loadHooksSuccess;
});