define('bitbucket/internal/feature/settings/hooks/components/basic-action-menu-items', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/widget/dropdown-menu/dropdown-menu'], function (module, exports, _aui, _propTypes, _react, _dropdownMenu) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var BasicActionMenuItems = function BasicActionMenuItems(_ref) {
        var hook = _ref.hook,
            inherited = _ref.inherited,
            onEnable = _ref.onEnable,
            onInherit = _ref.onInherit;
        var busy = hook.busy,
            enabled = hook.enabled;


        var handleEnable = function handleEnable() {
            onEnable(hook, true);
        };

        var handleDisable = function handleDisable() {
            onEnable(hook, false);
        };

        var handleInherit = function handleInherit() {
            onInherit && onInherit(hook);
        };

        return _react2.default.createElement(
            _dropdownMenu.DropdownMenuSection,
            {
                id: 'status-' + hook.details.key,
                label: _aui.I18n.getText('bitbucket.web.hooks.table.col.label.status')
            },
            _react2.default.createElement(
                _dropdownMenu.DropdownMenuItem,
                {
                    testId: 'enable',
                    onSelect: handleEnable,
                    isDisabled: busy || !inherited && enabled
                },
                _aui.I18n.getText('bitbucket.web.hooks.toggle.label.disabled')
            ),
            _react2.default.createElement(
                _dropdownMenu.DropdownMenuItem,
                {
                    testId: 'disable',
                    onSelect: handleDisable,
                    isDisabled: busy || !inherited && !enabled
                },
                _aui.I18n.getText('bitbucket.web.hooks.toggle.label.enabled')
            ),
            onInherit && _react2.default.createElement(
                _dropdownMenu.DropdownMenuItem,
                {
                    testId: 'inherit',
                    onSelect: handleInherit,
                    isDisabled: busy || inherited
                },
                _aui.I18n.getText('bitbucket.web.hooks.inherit.status.inherited')
            )
        );
    };

    BasicActionMenuItems.propTypes = {
        hook: _propTypes.object.isRequired,
        onEnable: _propTypes.func.isRequired,
        inherited: _propTypes.bool,
        onInherit: _propTypes.func
    };

    exports.default = BasicActionMenuItems;
    module.exports = exports['default'];
});