define('bitbucket/internal/feature/settings/hooks/components/enforce-project-settings-items', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/util/enforce-project-settings/util', 'bitbucket/internal/widget/dropdown-menu/dropdown-menu', './basic-action-menu-items', './hook-warning-dialog'], function (module, exports, _aui, _propTypes, _react, _util, _dropdownMenu, _basicActionMenuItems, _hookWarningDialog) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _basicActionMenuItems2 = _interopRequireDefault(_basicActionMenuItems);

    var _hookWarningDialog2 = _interopRequireDefault(_hookWarningDialog);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _slicedToArray = function () {
        function sliceIterator(arr, i) {
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = undefined;

            try {
                for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);

                    if (i && _arr.length === i) break;
                }
            } catch (err) {
                _d = true;
                _e = err;
            } finally {
                try {
                    if (!_n && _i["return"]) _i["return"]();
                } finally {
                    if (_d) throw _e;
                }
            }

            return _arr;
        }

        return function (arr, i) {
            if (Array.isArray(arr)) {
                return arr;
            } else if (Symbol.iterator in Object(arr)) {
                return sliceIterator(arr, i);
            } else {
                throw new TypeError("Invalid attempt to destructure non-iterable instance");
            }
        };
    }();

    var EnforceProjectSettingsItems = function EnforceProjectSettingsItems(_ref) {
        var hook = _ref.hook,
            onEnable = _ref.onEnable,
            onLockUpdate = _ref.onLockUpdate,
            isHookProjectOnly = _ref.isHookProjectOnly;
        var busy = hook.busy,
            restrictionState = hook.restrictionState;

        var _useState = (0, _react.useState)(false),
            _useState2 = _slicedToArray(_useState, 2),
            showWarningDialog = _useState2[0],
            setShowWarningDialog = _useState2[1];

        var onAddRestriction = function onAddRestriction() {
            onLockUpdate(hook, true);
            onCloseWarningDialog();
        };

        var onShowWarningDialog = function onShowWarningDialog() {
            setShowWarningDialog(true);
        };

        var onCloseWarningDialog = function onCloseWarningDialog() {
            setShowWarningDialog(false);
        };

        var onRemoveRestriction = function onRemoveRestriction() {
            onLockUpdate(hook, false);
        };

        var isHookLocked = (0, _util.isProjectSettingRestricted)(restrictionState);
        var isRestrictionUnmodifiable = (0, _util.isRestrictionProcessing)(restrictionState);

        return _react2.default.createElement(
            _react.Fragment,
            null,
            _react2.default.createElement(_basicActionMenuItems2.default, { hook: hook, onEnable: onEnable }),
            _util.isEnforceProjectSettingsEnabled && !isHookProjectOnly && _react2.default.createElement(
                _react.Fragment,
                null,
                _react2.default.createElement(
                    _dropdownMenu.DropdownMenuSection,
                    {
                        id: 'enforce-' + hook.details.key,
                        testId: 'hooks-restriction-toggle-' + hook.details.key,
                        label: _aui.I18n.getText('bitbucket.web.hooks.table.col.label.repoitory.settings')
                    },
                    _react2.default.createElement(
                        _dropdownMenu.DropdownMenuItem,
                        {
                            onSelect: onRemoveRestriction,
                            testId: 'remove-restriction',
                            isDisabled: !isHookLocked || busy || isRestrictionUnmodifiable
                        },
                        _aui.I18n.getText('bitbucket.web.hooks.table.col.actions.unlock')
                    ),
                    _react2.default.createElement(
                        _dropdownMenu.DropdownMenuItem,
                        {
                            onSelect: onShowWarningDialog,
                            testId: 'add-restriction',
                            isDisabled: isHookLocked || busy || isRestrictionUnmodifiable
                        },
                        _aui.I18n.getText('bitbucket.web.hooks.table.col.actions.lock')
                    )
                ),
                showWarningDialog && _react2.default.createElement(_hookWarningDialog2.default, {
                    onClick: onAddRestriction,
                    onClose: onCloseWarningDialog,
                    hook: hook
                })
            )
        );
    };

    EnforceProjectSettingsItems.propTypes = {
        hook: _propTypes.object.isRequired,
        onEnable: _propTypes.func.isRequired,
        onLockUpdate: _propTypes.func.isRequired,
        isHookProjectOnly: _propTypes.bool
    };

    exports.default = EnforceProjectSettingsItems;
    module.exports = exports['default'];
});