define('bitbucket/internal/feature/settings/hooks/components/enforce-project-settings-status-col', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/bbui/aui-react/spinner', 'bitbucket/internal/util/enforce-project-settings/util', 'bitbucket/internal/widget/icons/icons'], function (module, exports, _aui, _propTypes, _react, _spinner, _util, _icons) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _spinner2 = _interopRequireDefault(_spinner);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var EnforcedProjectSettingsStatusCol = function EnforcedProjectSettingsStatusCol(_ref) {
        var restrictionState = _ref.restrictionState,
            isHookRepoOrProjectOnly = _ref.isHookRepoOrProjectOnly;

        if (isHookRepoOrProjectOnly) return _react2.default.createElement(
            'td',
            { className: 'vertical-align-middle hook-customizable-cell' },
            '-'
        );

        var customizableLabel = void 0;

        if ((0, _util.isProjectSettingRestricted)(restrictionState)) {
            // locked
            customizableLabel = _react2.default.createElement(
                _react.Fragment,
                null,
                _react2.default.createElement(_icons.LockedIcon, { className: 'status-icon locked-icon' }),
                _aui.I18n.getText('bitbucket.web.hooks.table.col.repoitory.settings.customizable.not')
            );
        } else if ((0, _util.isRestrictionProcessing)(restrictionState)) {
            // processing or saving changes
            customizableLabel = _react2.default.createElement(
                'span',
                { className: 'busy-value' },
                _react2.default.createElement(_spinner2.default, null),
                _aui.I18n.getText('bitbucket.web.hooks.inherit.toggle.saving')
            );
        } else {
            // unlocked
            customizableLabel = _react2.default.createElement(
                _react.Fragment,
                null,
                _react2.default.createElement(_icons.UnLockedIcon, { className: 'status-icon' }),
                _aui.I18n.getText('bitbucket.web.hooks.table.col.repoitory.settings.customizable')
            );
        }

        return _react2.default.createElement(
            'td',
            { className: 'vertical-align-middle hook-customizable-cell' },
            customizableLabel
        );
    };

    EnforcedProjectSettingsStatusCol.propTypes = {
        restrictionState: (0, _propTypes.oneOf)(Object.values(_util.RestrictionProcessingStates)),
        isHookRepoOrProjectOnly: _propTypes.bool
    };

    exports.default = (0, _react.memo)(EnforcedProjectSettingsStatusCol);
    module.exports = exports['default'];
});