define('bitbucket/internal/feature/settings/hooks/components/hook-row', ['exports', '@atlassian/aui', 'classnames', 'lodash', 'prop-types', 'react', 'bitbucket/internal/enums', 'bitbucket/internal/util/enforce-project-settings/util', 'bitbucket/internal/widget/dropdown-menu/dropdown-menu', 'bitbucket/util/state', '../hook-type', './basic-action-menu-items', './enforce-project-settings-items', './enforce-project-settings-status-col', './inherited-status-col'], function (exports, _aui, _classnames, _lodash, _propTypes, _react, _enums, _util, _dropdownMenu, _state, _hookType, _basicActionMenuItems, _enforceProjectSettingsItems, _enforceProjectSettingsStatusCol, _inheritedStatusCol) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.isNotPersonalProject = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    var _state2 = _interopRequireDefault(_state);

    var _basicActionMenuItems2 = _interopRequireDefault(_basicActionMenuItems);

    var _enforceProjectSettingsItems2 = _interopRequireDefault(_enforceProjectSettingsItems);

    var _enforceProjectSettingsStatusCol2 = _interopRequireDefault(_enforceProjectSettingsStatusCol);

    var _inheritedStatusCol2 = _interopRequireDefault(_inheritedStatusCol);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var _invalidScopeI18nMap;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var PROJECT = _enums.ScopeType.PROJECT,
        REPOSITORY = _enums.ScopeType.REPOSITORY;


    var invalidScopeI18nMap = (_invalidScopeI18nMap = {}, _defineProperty(_invalidScopeI18nMap, PROJECT, function (hook) {
        return (0, _hookType.isMergeCheck)(hook) ? _aui.I18n.getText('bitbucket.web.merge.checks.invalid.for.project.scope') : _aui.I18n.getText('bitbucket.web.hooks.invalid.for.project.scope');
    }), _defineProperty(_invalidScopeI18nMap, REPOSITORY, function (hook) {
        return (0, _hookType.isMergeCheck)(hook) ? _aui.I18n.getText('bitbucket.web.merge.checks.invalid.for.repository.scope') : _aui.I18n.getText('bitbucket.web.hooks.invalid.for.repository.scope');
    }), _invalidScopeI18nMap);

    var isNotPersonalProject = exports.isNotPersonalProject = function isNotPersonalProject() {
        return _state2.default.getProject().type !== _enums.ProjectType.PERSONAL;
    };

    var HookRow = function HookRow(_ref) {
        var currentScope = _ref.currentScope,
            hook = _ref.hook,
            onEdit = _ref.onEdit,
            onEnable = _ref.onEnable,
            onLockUpdate = _ref.onLockUpdate,
            onInherit = _ref.onInherit;
        var details = hook.details,
            enabled = hook.enabled,
            scope = hook.scope,
            restrictionState = hook.restrictionState;
        var configFormKey = details.configFormKey,
            description = details.description,
            key = details.key,
            name = details.name,
            scopeTypes = details.scopeTypes;

        var disabled = !(0, _lodash.includes)(scopeTypes, currentScope.type);

        var isEditable = configFormKey && scope.type === currentScope.type;
        var inherited = scope.type === PROJECT;
        var isRepositoryRestricted = (0, _react.useMemo)(function () {
            return currentScope.type === REPOSITORY && (0, _util.isRestrictionPresent)(restrictionState);
        }, [currentScope.type, restrictionState]);

        var title = void 0;
        if (isRepositoryRestricted) title = _aui.I18n.getText('bitbucket.web.project.settings.enforce.hooks.locked.row.label');else if (disabled) title = invalidScopeI18nMap[currentScope.type](hook);

        var isRowDisabled = (0, _react.useMemo)(function () {
            return disabled || isRepositoryRestricted;
        }, [disabled, isRepositoryRestricted]);

        var statusLabel = (0, _react.useMemo)(function () {
            return enabled ? _aui.I18n.getText('bitbucket.web.hooks.table.col.status.enabled') : _aui.I18n.getText('bitbucket.web.hooks.table.col.status.disabled');
        }, [enabled]);

        var handleEditClicked = function handleEditClicked() {
            onEdit(hook);
        };

        // no need to show restriction action for project only hooks
        var isHookProjectOnly = (0, _react.useMemo)(function () {
            return !(0, _lodash.includes)(scopeTypes, REPOSITORY);
        }, [scopeTypes]);
        // no need to show inherit action for repo only hooks
        var isHookRepoOnly = (0, _react.useMemo)(function () {
            return !(0, _lodash.includes)(scopeTypes, PROJECT);
        }, [scopeTypes]);

        return _react2.default.createElement(
            'tr',
            { title: title },
            _react2.default.createElement(
                'td',
                { className: 'hook-summary-cell' },
                _react2.default.createElement(
                    'h4',
                    null,
                    name
                ),
                _react2.default.createElement(
                    'p',
                    null,
                    description
                )
            ),
            _react2.default.createElement(
                'td',
                { className: 'vertical-align-middle hook-status-cell' },
                _react2.default.createElement(
                    'span',
                    {
                        className: (0, _classnames2.default)('aui-lozenge aui-lozenge-subtle', {
                            'aui-lozenge-success': enabled
                        })
                    },
                    statusLabel
                )
            ),
            currentScope.type === _enums.ScopeType.PROJECT && _util.isEnforceProjectSettingsEnabled && _react2.default.createElement(_enforceProjectSettingsStatusCol2.default, {
                restrictionState: restrictionState,
                isHookRepoOrProjectOnly: isHookRepoOnly || isHookProjectOnly
            }),
            currentScope.type === _enums.ScopeType.REPOSITORY && isNotPersonalProject() && _react2.default.createElement(_inheritedStatusCol2.default, {
                restrictionState: restrictionState,
                type: scope.type,
                isHookRepoOnly: isHookRepoOnly
            }),
            _react2.default.createElement(
                'td',
                { className: 'hook-toggle-cell' },
                _react2.default.createElement(
                    _dropdownMenu.DropdownMenu,
                    { id: key, disabled: isRowDisabled },
                    isEditable && enabled && _react2.default.createElement(
                        _dropdownMenu.DropdownMenuSection,
                        { id: 'edit-' + key },
                        _react2.default.createElement(
                            _dropdownMenu.DropdownMenuItem,
                            { onSelect: handleEditClicked, testId: 'edit-hook' },
                            _aui.I18n.getText('bitbucket.web.button.edit')
                        )
                    ),
                    currentScope.type === REPOSITORY ? _react2.default.createElement(_basicActionMenuItems2.default, _extends({
                        hook: hook,
                        inherited: inherited,
                        onEnable: onEnable
                        // for personal projects hide the inherit menu
                    }, isNotPersonalProject() && !(isHookRepoOnly || isHookProjectOnly) && { onInherit: onInherit })) : _react2.default.createElement(_enforceProjectSettingsItems2.default, {
                        hook: hook,
                        onEnable: onEnable,
                        onLockUpdate: onLockUpdate,
                        isHookProjectOnly: isHookProjectOnly
                    })
                )
            )
        );
    };

    HookRow.propTypes = {
        currentScope: (0, _propTypes.shape)({
            type: (0, _propTypes.oneOf)(Object.values(_enums.ScopeType))
        }).isRequired,
        hook: _propTypes.object.isRequired,
        onEdit: _propTypes.func.isRequired,
        onEnable: _propTypes.func.isRequired,
        onLockUpdate: _propTypes.func.isRequired,
        onInherit: _propTypes.func.isRequired
    };

    exports.default = HookRow;
});