define('bitbucket/internal/feature/settings/hooks/components/hook-warning-dialog', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/bbui/aui-react/dialog', '../hook-type'], function (module, exports, _aui, _propTypes, _react, _dialog, _hookType) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _dialog2 = _interopRequireDefault(_dialog);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var DialogTitle = function DialogTitle() {
        return _react2.default.createElement(
            'span',
            { className: 'warning-title' },
            _react2.default.createElement('span', { className: 'aui-icon aui-icon-small aui-iconfont-warning warning-icon' }),
            _aui.I18n.getText('bitbucket.web.util.enforce.settings.warning.dialog.title')
        );
    };

    var DialogFooter = function DialogFooter(_ref) {
        var onClick = _ref.onClick,
            onCancel = _ref.onCancel;
        return _react2.default.createElement(
            'div',
            null,
            _react2.default.createElement(
                'button',
                { className: 'aui-button confirm-button', onClick: onClick },
                _aui.I18n.getText('bitbucket.web.util.enforce.settings.warning.dialog.confirm')
            ),
            _react2.default.createElement(
                'button',
                { onClick: onCancel, className: 'aui-button', autoFocus: true },
                _aui.I18n.getText('bitbucket.web.button.cancel')
            )
        );
    };

    var HookWarningDialog = function HookWarningDialog(_ref2) {
        var onClick = _ref2.onClick,
            onClose = _ref2.onClose,
            hook = _ref2.hook;

        return _react2.default.createElement(
            _dialog2.default,
            {
                id: 'hook-warning-dialog',
                size: _dialog.DialogSize.SMALL,
                titleContent: _react2.default.createElement(DialogTitle, null),
                onClose: onClose,
                footerActionContent: _react2.default.createElement(DialogFooter, { onClick: onClick, onCancel: onClose }),
                modal: true
            },
            (0, _hookType.isMergeCheck)(hook) ? _react2.default.createElement(
                'p',
                null,
                _aui.I18n.getText('bitbucket.web.merge.checks.enforce.settings.warning.dialog.description', hook.details.name)
            ) : _react2.default.createElement(
                'p',
                null,
                _aui.I18n.getText('bitbucket.web.hooks.enforce.settings.warning.dialog.description', hook.details.name)
            )
        );
    };

    HookWarningDialog.propTypes = {
        hook: _propTypes.object.isRequired,
        onClick: _propTypes.func.isRequired,
        onClose: _propTypes.func.isRequired
    };

    exports.default = HookWarningDialog;
    module.exports = exports['default'];
});