define('bitbucket/internal/feature/settings/hooks/components/hooks-table', ['module', 'exports', '@atlassian/aui', 'classnames', 'lodash', 'react', 'bitbucket/internal/enums', 'bitbucket/internal/util/enforce-project-settings/util', '../hook-type', './hook-row'], function (module, exports, _aui, _classnames, _lodash, _react, _enums, _util, _hookType, _hookRow) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    var _hookRow2 = _interopRequireDefault(_hookRow);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var PROJECT = _enums.ScopeType.PROJECT,
        REPOSITORY = _enums.ScopeType.REPOSITORY;

    var RESTRICTION_POLLING_INTERVAL_MILLISECONDS = 2000;

    var typeToClassSuffix = function typeToClassSuffix(type) {
        return type.toLowerCase().replace('_', '-');
    };

    // returns true if any of the hook has processing restricionState
    var isAnyRestrictionProcessing = function isAnyRestrictionProcessing(hooks) {
        return hooks.some(function (hook) {
            return (0, _util.isRestrictionProcessing)(hook.restrictionState);
        });
    };

    var HooksTable = function HooksTable(_ref) {
        var currentScope = _ref.currentScope,
            getLocksForHooksAndChecks = _ref.getLocksForHooksAndChecks,
            hooks = _ref.hooks,
            onEdit = _ref.onEdit,
            onEnable = _ref.onEnable,
            onInherit = _ref.onInherit,
            onLockUpdate = _ref.onLockUpdate,
            type = _ref.type;

        var pollTimerRunning = (0, _react.useRef)(null);
        var isProcessing = isAnyRestrictionProcessing(hooks);

        (0, _react.useEffect)(function () {
            // clear interval if processed and timer is running
            if (pollTimerRunning.current) {
                if (!isProcessing) {
                    clearInterval(pollTimerRunning.current);
                    pollTimerRunning.current = null;
                }
            }
            // start poll if processing and timer is not running already
            else if (isProcessing && currentScope.type === PROJECT) {
                    pollTimerRunning.current = setInterval(function () {
                        getLocksForHooksAndChecks().catch(function () {
                            // Stop polling on error.
                            clearInterval(pollTimerRunning.current);
                        });
                    }, RESTRICTION_POLLING_INTERVAL_MILLISECONDS);
                }

            return function () {
                return clearInterval(pollTimerRunning.current);
            };
        }, [currentScope.type, getLocksForHooksAndChecks, isProcessing, pollTimerRunning]);

        var sortedHooks = (0, _lodash.sortBy)(hooks, function (hook) {
            return !(0, _lodash.includes)(hook.details.scopeTypes, currentScope.type);
        });

        return _react2.default.createElement(
            'table',
            {
                className: (0, _classnames2.default)('aui table', 'hooks-table', 'hooks-table-' + typeToClassSuffix(type))
            },
            _react2.default.createElement(
                'thead',
                null,
                _react2.default.createElement(
                    'tr',
                    null,
                    _react2.default.createElement(
                        'th',
                        { scope: 'col' },
                        _aui.I18n.getText('bitbucket.web.hooks.table.col.label.title')
                    ),
                    _react2.default.createElement(
                        'th',
                        { scope: 'col' },
                        _aui.I18n.getText('bitbucket.web.hooks.table.col.label.status')
                    ),
                    currentScope.type === PROJECT && _util.isEnforceProjectSettingsEnabled && _react2.default.createElement(
                        'th',
                        { scope: 'col' },
                        _aui.I18n.getText('bitbucket.web.hooks.table.col.label.repoitory.settings')
                    ),
                    currentScope.type === REPOSITORY && (0, _hookRow.isNotPersonalProject)() && _react2.default.createElement(
                        'th',
                        { scope: 'col' },
                        _aui.I18n.getText('bitbucket.web.hooks.table.col.label.inherited')
                    ),
                    _react2.default.createElement(
                        'th',
                        { scope: 'col' },
                        _aui.I18n.getText('bitbucket.web.actions')
                    )
                )
            ),
            _react2.default.createElement(
                'tbody',
                null,
                sortedHooks.length ? sortedHooks.map(function (hook) {
                    return _react2.default.createElement(_hookRow2.default, {
                        currentScope: currentScope,
                        hook: hook,
                        key: hook.details.key,
                        onEdit: onEdit,
                        onEnable: onEnable,
                        onInherit: onInherit,
                        onLockUpdate: onLockUpdate,
                        getLocksForHooksAndChecks: getLocksForHooksAndChecks
                    });
                }) : _react2.default.createElement(
                    'tr',
                    { className: 'no-hooks-message' },
                    _react2.default.createElement(
                        'td',
                        { colSpan: '4' },
                        type === _hookType.PRE_PULL_REQUEST_MERGE ? _aui.I18n.getText('bitbucket.web.merge.checks.table.empty') : _aui.I18n.getText('bitbucket.web.hooks.table.empty')
                    )
                )
            )
        );
    };

    exports.default = HooksTable;
    module.exports = exports['default'];
});