define('bitbucket/internal/feature/settings/hooks/hook-config-form-util', ['module', 'exports', '@atlassian/aui', 'lodash', 'wrm/require'], function (module, exports, _aui, _lodash, _require) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.default = getHookConfigView;

    var _require2 = _interopRequireDefault(_require);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var viewCache = new Map();

    function getHookConfigView(editingHook) {
        var _editingHook$details = editingHook.details,
            configFormKey = _editingHook$details.configFormKey,
            configFormView = _editingHook$details.configFormView;

        var loadError = new Error(_aui.I18n.getText('bitbucket.web.hooks.config.view.load.error', editingHook.details.name));

        var wrapView = function wrapView(view) {
            return function (ctx) {
                try {
                    return view(ctx);
                } catch (e) {
                    console.error('Failed to render hook config view', e);

                    return new Error(_aui.I18n.getText('bitbucket.web.hooks.config.view.render.error', editingHook.details.name));
                }
            };
        };

        if (viewCache.has(configFormKey)) {
            return Promise.resolve(viewCache.get(configFormKey));
        }

        return (0, _require2.default)('wrc!' + configFormKey).then(function () {
            // If configFormView is a string, evaluate it to get the function
            var viewFunction = (0, _lodash.get)(window, configFormView, null);

            return viewFunction ? wrapView(viewFunction) : Promise.reject(loadError);
        }, function () {
            return loadError;
        }).then(function (view) {
            viewCache.set(configFormKey, view);

            return view;
        });
    }
    module.exports = exports['default'];
});