define('bitbucket/internal/feature/settings/hooks/reducers/paging', ['module', 'exports', 'lodash', 'redux', 'bitbucket/internal/util/store/reducers', '../actions'], function (module, exports, _lodash, _redux, _reducers, _actions) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    exports.default = (0, _redux.combineReducers)({
        hooks: (0, _reducers.reduceByType)({}, _defineProperty({}, _actions.LOAD_HOOKS_SUCCESS, function (state, _ref) {
            var type = _ref.meta.type,
                page = _ref.payload;

            var oldIds = (0, _lodash.get)(state, [type, 'ids'], []);

            return _extends({}, state, _defineProperty({}, type, {
                lastPageMeta: (0, _lodash.omit)(page, 'values'),
                ids: oldIds.concat(page.values.map(function (hook) {
                    return hook.details.key;
                }))
            }));
        }))
    });
    module.exports = exports['default'];
});