define('bitbucket/internal/feature/timezone/onboarding/timezone-onboarding', ['module', 'exports', '@atlassian/aui', 'jquery', 'bitbucket/internal/feature/alerts/alerts', 'bitbucket/internal/feature/alerts/constants', 'bitbucket/internal/model/page-state', 'bitbucket/internal/util/ajax', 'bitbucket/internal/util/client-storage', 'bitbucket/internal/util/events', 'bitbucket/internal/util/feature-enabled', 'bitbucket/util/navbuilder'], function (module, exports, _aui, _jquery, _alerts, _constants, _pageState, _ajax, _clientStorage, _events, _featureEnabled, _navbuilder) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _pageState2 = _interopRequireDefault(_pageState);

    var ajax = _interopRequireWildcard(_ajax);

    var clientStorage = _interopRequireWildcard(_clientStorage);

    var _events2 = _interopRequireDefault(_events);

    var featureEnabled = _interopRequireWildcard(_featureEnabled);

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var OFFSET_STORAGE_KEY = 'bitbucket_known_time_zone_offset';
    var OFFSET_SETTING_KEY = 'USER_BROWSER_TIME_ZONE_OFFSET';

    /**
     * Is time zone onboarding enabled on the server?
     * getFromProvider is essentially synchronous even though there is a promise API,
     * so this should always resolve before the first MarkupAttachments is initialised.
     * If it doesn't, onboarding will default to being disabled.
     */
    var timeZoneOnboardingEnabled;
    featureEnabled.getFromProvider('user.time.zone.onboarding').done(function (enabled) {
        timeZoneOnboardingEnabled = enabled;
    });

    /**
     * Fires an event for analytics purposes
     *
     * @param {String} name the name of the event to fire
     */
    function analyticsEvent(name) {
        _events2.default.trigger('bitbucket.internal.DO_NOT_USE.ui.time.zone.onboarding.' + name);
    }

    /**
     * Event handler which redirects to the user account page.
     * Fires an analytics event and updates the user setting before redirecting.
     */
    function changeTimeZone() {
        analyticsEvent('changed');
        setKnownBrowserOffset();
    }

    function getBrowserOffsetAs(func) {
        return func(new Date().getTimezoneOffset());
    }

    /**
     * @returns {string|null} the known browser offset from local storage
     */
    function getLocalKnownBrowserOffset() {
        var knownBrowserOffset = clientStorage.getItem(OFFSET_STORAGE_KEY);

        return knownBrowserOffset ? String(knownBrowserOffset) : null;
    }

    /**
     * Will try to read the known offset value from the user settings REST endpoint.
     *
     * @returns {Promise<string>} a promise that resolves with the known browser offset
     */
    function getServerKnownBrowserOffset() {
        var user = _pageState2.default.getCurrentUser();

        if (user) {
            return ajax.rest({
                url: nav.rest().users(user.getSlug()).addPathComponents('settings').build(),
                type: 'GET',
                statusCode: {
                    '*': false // We don't ever want to show an error to the user when this fails
                }
            }).then(function (data) {
                var knownOffset = String(data[OFFSET_SETTING_KEY]);
                saveOffset(knownOffset);
                if (knownOffset != null) {
                    return knownOffset;
                }

                return null;
            });
        }

        return _jquery2.default.Deferred().reject().promise();
    }

    function getServerOffsetAs(func) {
        return func((0, _jquery2.default)('#content').attr('data-timezone'));
    }

    /**
     * @param {string} knownBrowserOffset
     * @returns {boolean} true if the user's browser offset is not equal to the current browser offset.
     */
    function knownOffsetHasChanged(knownBrowserOffset) {
        return knownBrowserOffset !== getBrowserOffsetAs(String);
    }

    /**
     * Saves the offset to local storage
     * @param offset
     */
    function saveOffset(offset) {
        clientStorage.setItem(OFFSET_STORAGE_KEY, offset);
    }

    /**
     * Set the currently reported browser offset as the known offset.
     *
     * @returns {Promise} a promise that completes when the REST request completes (or fails)
     */
    function setKnownBrowserOffset() {
        var data = {};
        data[OFFSET_SETTING_KEY] = getBrowserOffsetAs(String);

        return ajax.rest({
            url: nav.rest().users(_pageState2.default.getCurrentUser().getSlug()).addPathComponents('settings').build(),
            type: 'POST',
            data: data,
            statusCode: {
                '*': false // We don't ever want to show an error to the user when this fails
            }
        }).done(function () {
            saveOffset(data[OFFSET_SETTING_KEY]);
        });
    }

    function onReady() {
        if (timeZoneOnboardingEnabled) {
            if (getBrowserOffsetAs(Number) !== getServerOffsetAs(Number)) {
                if (knownOffsetHasChanged(getLocalKnownBrowserOffset())) {
                    return getServerKnownBrowserOffset() // Verify the Server agrees we should show the flag
                    .done(function (knownOffset) {
                        if (knownOffsetHasChanged(knownOffset)) {
                            analyticsEvent('shown');
                            (0, _alerts.add)({
                                title: AJS.I18n.getText('bitbucket.web.timezone.onboarding.title'),
                                description: AJS.I18n.getText('bitbucket.web.timezone.onboarding.mismatch'),
                                closeable: true,
                                closeCallback: function closeCallback() {
                                    analyticsEvent('dismissed');
                                    setKnownBrowserOffset();
                                },
                                anchorText: AJS.I18n.getText('bitbucket.web.timezone.onboarding.change'),
                                anchorLink: nav.newBuilder('account').build(),
                                anchorCallback: changeTimeZone,
                                type: _constants.AlertType.INFO
                            });
                        }
                    });
                }
            }
        }
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});