define('bitbucket/internal/feature/user/access-key-multi-selector/access-key-multi-selector', ['module', 'exports', '@atlassian/aui', 'jquery', 'bitbucket/internal/widget/searchable-multi-selector/searchable-multi-selector', 'bitbucket/util/navbuilder', 'bitbucket/util/state'], function (module, exports, _aui, _jquery, _searchableMultiSelector, _navbuilder, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _searchableMultiSelector2 = _interopRequireDefault(_searchableMultiSelector);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var AccessKeyMultiSelector = function (_SearchableMultiSelec) {
        _inherits(AccessKeyMultiSelector, _SearchableMultiSelec);

        function AccessKeyMultiSelector($field, options) {
            _classCallCheck(this, AccessKeyMultiSelector);

            return _possibleConstructorReturn(this, (AccessKeyMultiSelector.__proto__ || Object.getPrototypeOf(AccessKeyMultiSelector)).call(this, $field, _jquery2.default.extend(true, AccessKeyMultiSelector.defaults, options)));
        }

        return AccessKeyMultiSelector;
    }(_searchableMultiSelector2.default);

    AccessKeyMultiSelector.defaults = {
        hasAvatar: true,
        url: function url() {
            return nav.rest('keys', 'latest').repository(_state2.default.getRepository()).addPathComponents('ssh').build();
        },
        selectionTemplate: function selectionTemplate(_ref) {
            var key = _ref.key;

            return bitbucket.internal.widget.avatar.accessKeyAvatar.accessKey({
                size: 'xsmall',
                label: key.label,
                text: key.text
            });
        },
        resultTemplate: function resultTemplate(_ref2) {
            var key = _ref2.key;

            return bitbucket.internal.widget.avatar.accessKeyAvatar.accessKeyWithText({
                size: 'small',
                label: key.label,
                text: key.text
            });
        },
        generateId: function generateId(_ref3) {
            var key = _ref3.key;
            return key.id;
        },
        generateText: function generateText(_ref4) {
            var key = _ref4.key;
            return key.label;
        },
        inputTooShortTemplate: function defaultInputTooShortTemplate() {
            return AJS.escapeHtml(AJS.I18n.getText('bitbucket.web.access.key.multi.selector.help'));
        },
        noMatchesTemplate: function defaultNoMatchesTemplate() {
            return AJS.escapeHtml(AJS.I18n.getText('bitbucket.web.access.key.multi.selector.no.match'));
        }
    };
    exports.default = AccessKeyMultiSelector;
    module.exports = exports['default'];
});