define('bitbucket/internal/feature/user/group-multi-selector/group-multi-selector', ['module', 'exports', '@atlassian/aui', 'jquery', 'bitbucket/internal/widget/searchable-multi-selector/searchable-multi-selector', 'bitbucket/util/navbuilder'], function (module, exports, _aui, _jquery, _searchableMultiSelector, _navbuilder) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _searchableMultiSelector2 = _interopRequireDefault(_searchableMultiSelector);

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function getGroupName(groupOrGroupName) {
        return typeof groupOrGroupName === 'string' ? groupOrGroupName : groupOrGroupName.name;
    }

    function GroupMultiSelector($field, options) {
        _searchableMultiSelector2.default.call(this, $field, options);
    }

    _jquery2.default.extend(true, GroupMultiSelector.prototype, _searchableMultiSelector2.default.prototype, {
        defaults: {
            hasAvatar: true,
            url: nav.rest().groups().build(),
            selectionTemplate: function selectionTemplate(group) {
                return bitbucket.internal.widget.avatar.groupAvatar.groupAvatarWithName({
                    size: 'xsmall',
                    name: getGroupName(group)
                });
            },
            resultTemplate: function resultTemplate(group) {
                return bitbucket.internal.widget.avatar.groupAvatar.groupAvatarWithName({
                    size: 'small',
                    name: getGroupName(group)
                });
            },
            generateId: getGroupName,
            generateText: getGroupName,
            inputTooShortTemplate: function defaultInputTooShortTemplate() {
                return AJS.escapeHtml(AJS.I18n.getText('bitbucket.web.group.multi.selector.help'));
            },
            noMatchesTemplate: function defaultNoMatchesTemplate() {
                return AJS.escapeHtml(AJS.I18n.getText('bitbucket.web.group.multi.selector.no.match'));
            }
        }
    });

    exports.default = GroupMultiSelector;
    module.exports = exports['default'];
});