define('bitbucket/internal/feature/user/user-table/user-table', ['module', 'exports', '@atlassian/aui', 'jquery', 'bitbucket/internal/widget/paged-table/paged-table', 'bitbucket/util/navbuilder'], function (module, exports, _aui, _jquery, _pagedTable, _navbuilder) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _pagedTable2 = _interopRequireDefault(_pagedTable);

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function UserTable(options) {
        _pagedTable2.default.call(this, _jquery2.default.extend({
            filterable: true,
            noneMatchingMessageHtml: AJS.escapeHtml(AJS.I18n.getText('bitbucket.web.user.search.nomatch')),
            noneFoundMessageHtml: AJS.escapeHtml(AJS.I18n.getText('bitbucket.web.user.search.nousers')),
            paginationContext: 'user-table'
        }, options));
    }

    _jquery2.default.extend(UserTable.prototype, _pagedTable2.default.prototype);

    UserTable.prototype.buildUrl = function (start, limit, filter) {
        var params = {
            start: start,
            limit: limit,
            avatarSize: bitbucket.internal.widget.avatar.avatar.avatarSizeInPx({ size: 'small' })
        };

        if (filter) {
            params.filter = filter;
        }

        return nav.admin().users().withParams(params).build();
    };

    UserTable.prototype.handleNewRows = function (userPage, attachmentMethod) {
        this.$table.find('tbody')[attachmentMethod](bitbucket.internal.feature.user.userTable.userTable.userRows({
            users: userPage.values
        }));
    };

    exports.default = UserTable;
    module.exports = exports['default'];
});