define('bitbucket/internal/impl/data-provider/pull-request-list', ['module', 'exports', 'lodash', 'bitbucket/internal/bbui/data-provider/pull-request-list', 'bitbucket/internal/util/object', 'bitbucket/util/navbuilder', 'bitbucket/util/state'], function (module, exports, _lodash, _pullRequestList, _object, _navbuilder, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _lodash2 = _interopRequireDefault(_lodash);

    var _pullRequestList2 = _interopRequireDefault(_pullRequestList);

    var _object2 = _interopRequireDefault(_object);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function PullRequestListDataProvider(options) {
        _pullRequestList2.default.apply(this, arguments);
    }
    _object2.default.inherits(PullRequestListDataProvider, _pullRequestList2.default);

    PullRequestListDataProvider.prototype._getBuilder = function () {
        return nav.rest().repository(_state2.default.getRepository()).allPullRequests().withParams({
            avatarSize: bitbucket.internal.widget.avatar.avatar.avatarSizeInPx({
                size: 'medium'
            }),
            order: 'newest'
        }).withParams(filterParams(this.filter));
    };

    PullRequestListDataProvider.prototype._transform = function (data) {
        return data.values || [];
    };

    PullRequestListDataProvider.prototype._errorTransform = function (errors) {
        return errors;
    };

    /**
     * Translate the filter values to REST params.
     * Any null values will not be passed along
     *
     * @param {Object} filter - the current filter state
     * @returns {Object}
     */
    function filterParams(filter) {
        var params = {};

        if (filter.target_ref_id) {
            params.at = filter.target_ref_id;
        }

        if (filter.state) {
            params.state = filter.state;
        }

        if (filter.filterText) {
            params.filterText = filter.filterText;
        }

        /**
         *  we just pass draft as false, if it is explicitly false, otherwise we don't pass the filter
         */
        if (filter.draft === false) {
            params.draft = filter.draft;
        }

        var participants = [maybeParticipant('AUTHOR', filter.author_id), maybeParticipant('REVIEWER', filter.reviewer_id)].filter(_lodash2.default.identity);

        participants.forEach(function (participant, i) {
            i++;
            params['role.' + i] = participant.role;
            params['username.' + i] = participant.username;
        });

        function maybeParticipant(role, username) {
            if (!username) {
                return null;
            }

            return {
                role: role,
                username: username
            };
        }

        return params;
    }

    exports.default = PullRequestListDataProvider;
    module.exports = exports['default'];
});