define('bitbucket/internal/impl/urls', ['module', 'exports', 'bitbucket/internal/bbui/javascript-errors/javascript-errors', 'bitbucket/internal/bbui/urls/urls', 'bitbucket/internal/util/object', 'bitbucket/util/navbuilder', 'bitbucket/util/state'], function (module, exports, _javascriptErrors, _urls, _object, _navbuilder, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _javascriptErrors2 = _interopRequireDefault(_javascriptErrors);

    var _urls2 = _interopRequireDefault(_urls);

    var _object2 = _interopRequireDefault(_object);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function Urls() {
        _urls2.default.call(this);
    } /* globals bitbucket_help_url:false */


    _object2.default.inherits(Urls, _urls2.default);

    var fileChanges = function fileChanges(repository, commitRange) {
        //throw new NotImplementedError();
    };

    Urls.prototype.avatarUrl = function (person, size) {
        return nav._avatarUrl(person, size).build();
    };

    Urls.prototype.pullRequest = function (pullRequest) {
        return nav.repository(_state2.default.getRepository()).pullRequest(pullRequest).build();
    };

    Urls.prototype.inboxPullRequest = function (proj, repo, pullRequest) {
        return nav.project(proj).repo(repo).pullRequest(pullRequest).build();
    };

    Urls.prototype.createPullRequest = function (repository) {
        return nav.project(repository.project).repo(repository).createPullRequest().build();
    };

    Urls.prototype.allPullRequests = function (repository, state) {
        if (state) {
            return nav.project(repository.project).repo(repository).allPullRequests().state(state).build();
        }

        return nav.project(repository.project).repo(repository).allPullRequests().build();
    };

    Urls.prototype.help = function (key) {
        switch (key) {
            case 'help.git.mesh.availability-zones':
                return bitbucket_help_url('bitbucket.help.git.mesh.availability-zones');
            case 'help.mirroring.clone.dialog':
                return bitbucket_help_url('bitbucket.help.mirroring.clone.dialog');
            case 'help.mirroring.getting.started':
                return bitbucket_help_url('bitbucket.help.mirroring.getting.started');
            case 'help.mirroring.setup':
                return bitbucket_help_url('bitbucket.help.mirroring.setup.guide');
            case 'help.pull.request':
                return bitbucket_help_url('bitbucket.help.pull.request');
            default:
                throw new _javascriptErrors2.default.NotImplementedError();
        }
    };

    Urls.prototype.search = function (terms) {
        return nav.search(terms).build();
    };

    Urls.prototype.project = function (project) {
        return nav.project(project).build();
    };

    Urls.prototype.repo = function (repository) {
        return nav.project(repository.project).repo(repository).build();
    };

    Urls.prototype.user = function (user) {
        return user.slug ? nav.user(user.slug).build() : undefined;
    };

    Urls.prototype.remote = function (repository) {
        return nav.project(repository.project.key).repo(repository.slug).clone(repository.scmId).buildAbsolute();
    };

    exports.default = new Urls();
    module.exports = exports['default'];
});