define('bitbucket/internal/layout/base/menu/repositories/recent', ['module', 'exports', 'jquery', 'react', 'react-dom', 'bitbucket/internal/feature/repository/search-results/search-results-list', 'bitbucket/internal/util/html', 'bitbucket/internal/util/shortcuts', 'bitbucket/util/events', 'bitbucket/util/navbuilder', 'bitbucket/util/server'], function (module, exports, _jquery, _react, _reactDom, _searchResultsList, _html, _shortcuts, _events, _navbuilder, _server) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    var _searchResultsList2 = _interopRequireDefault(_searchResultsList);

    var _html2 = _interopRequireDefault(_html);

    var shortcuts = _interopRequireWildcard(_shortcuts);

    var _events2 = _interopRequireDefault(_events);

    var nav = _interopRequireWildcard(_navbuilder);

    var server = _interopRequireWildcard(_server);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var MAX_REPO_ITEM_COUNT = 10;

    function initMenu(menuTriggerId) {
        var $menuTrigger = (0, _jquery2.default)('#' + menuTriggerId);
        var $menu = (0, _jquery2.default)('#' + _html2.default.sanitizeId($menuTrigger.attr('aria-controls'))).addClass('recent-repositories-menu');
        var REPOLIST_CONTAINER_ID = 'recent-repositories-list-container';

        var $auiDropdown2Section = $menu.find('.aui-dropdown2-section');
        $auiDropdown2Section.addClass('repository-list-container').find('ul').addClass('repository-list');
        $auiDropdown2Section.first().attr('id', REPOLIST_CONTAINER_ID);
        var $repoList = $menu.find('.recent-repositories-section ul');
        var $loading = (0, _jquery2.default)(bitbucket.internal.layout.base.menu.repositories.recent.loadingRecentReposMenuItem());

        shortcuts.bind('recentRepositories', function () {
            return $menuTrigger.click();
        });

        // Trigger UI events
        $menu.on('aui-dropdown2-show', function () {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.ui.nav.repositories.opened');
        });
        $menu.find('.public-repo-list-link-section').on('click', 'a', function () {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.ui.nav.repositories.public.clicked');
        });

        var recentRepoItemClick = function recentRepoItemClick(e) {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.ui.nav.repositories.item.clicked', null, {
                repositoryId: e.currentTarget.dataset.repositoryId
            });
        };

        $repoList.append($loading);

        var fetchRecentRepos = function fetchRecentRepos() {
            server.rest({
                url: nav.rest().profile().recent().repos().withParams({
                    avatarSize: bitbucket.internal.widget.avatar.avatar.avatarSizeInPx({
                        size: 'medium'
                    }),
                    limit: MAX_REPO_ITEM_COUNT
                }).build(),
                statusCode: {
                    '*': false
                }
            }).done(function (data) {
                if (data && data.size) {
                    $repoList.remove();
                    _reactDom2.default.render(_react2.default.createElement(_searchResultsList2.default, {
                        repositories: data.values,
                        onItemClick: recentRepoItemClick
                    }), document.getElementById(REPOLIST_CONTAINER_ID));
                } else {
                    $repoList.append((0, _jquery2.default)(bitbucket.internal.layout.base.menu.repositories.recent.noRecentReposMenuItem()));
                }
                // Fire an event with the recent repository data so that other parts of Stash have access to it
                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.feature.repositories.recent.loaded', this, data);
            }).fail(function () {
                $repoList.append((0, _jquery2.default)(bitbucket.internal.layout.base.menu.repositories.recent.errorLoadingRecentReposMenuItem()));
            }).always(function () {
                $loading.remove();
            });
        };

        //Load only once all other resources have loaded
        (0, _jquery2.default)(window).on('load', fetchRecentRepos);
    }

    exports.default = {
        initMenu: initMenu
    };
    module.exports = exports['default'];
});