define('bitbucket/internal/layout/branch/branch-layout-analytics', ['module', 'exports', 'jquery', 'lodash', 'bitbucket/internal/util/events', 'bitbucket/util/navbuilder', 'bitbucket/util/state'], function (module, exports, _jquery, _lodash, _events, _navbuilder, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _events2 = _interopRequireDefault(_events);

    var navBuilder = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var CONTEXT = 'selector';

    function branchActionsAnalytics(data) {
        if (data.context !== CONTEXT) {
            return;
        }
        var pages = ['commits', 'browse', 'branches'];

        function onPage(pageName) {
            return _lodash2.default.startsWith(window.location.pathname, navBuilder.repository(_state2.default.getRepository())[pageName]().build());
        }

        var page = _lodash2.default.find(pages, onPage);

        _events2.default.trigger('bitbucket.internal.DO_NOT_USE.ui.branch-selector.actions.item.clicked', null, {
            webItemKey: data.webItemKey,
            source: page
        });
    }

    function initLayoutAnalytics($actionsMenu) {
        $actionsMenu.on('aui-dropdown2-show', function () {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.ui.branch-selector.actions.opened');
        });

        $actionsMenu.on('click', 'a', function () {
            branchActionsAnalytics({
                context: CONTEXT,
                webItemKey: (0, _jquery2.default)(this).attr('data-web-item-key')
            });
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.branch-copy.branchNameCopied', branchActionsAnalytics);
    }

    exports.default = {
        initLayoutAnalytics: initLayoutAnalytics,
        CONTEXT: CONTEXT
    };
    module.exports = exports['default'];
});