define('bitbucket/internal/layout/branch/branch', ['module', 'exports', '@atlassian/aui', 'jquery', 'lodash', 'bitbucket/internal/feature/repository/revision-reference-selector/revision-reference-selector', 'bitbucket/internal/layout/branch/branch-layout-analytics', 'bitbucket/internal/model/page-state', 'bitbucket/internal/model/revision-reference', 'bitbucket/internal/util/events', 'bitbucket/internal/util/shortcuts', 'bitbucket/util/navbuilder'], function (module, exports, _aui, _jquery, _lodash, _revisionReferenceSelector, _branchLayoutAnalytics, _pageState, _revisionReference, _events, _shortcuts, _navbuilder) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _revisionReferenceSelector2 = _interopRequireDefault(_revisionReferenceSelector);

    var _branchLayoutAnalytics2 = _interopRequireDefault(_branchLayoutAnalytics);

    var _pageState2 = _interopRequireDefault(_pageState);

    var _revisionReference2 = _interopRequireDefault(_revisionReference);

    var _events2 = _interopRequireDefault(_events);

    var shortcuts = _interopRequireWildcard(_shortcuts);

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function onReady(revisionSelector) {
        var refQueryParam = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'at';
        var isCSEEnabled = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
        var hasRepoWrite = arguments[3];
        var hasRepoFeatureArchive = arguments[4];
        var canCloneRepository = arguments[5];
        var isRepositoryEmpty = arguments[6];
        var hasRepoFeatureCompare = arguments[7];

        var addUrlToResults = function addUrlToResults(results) {
            results = _revisionReferenceSelector2.default.prototype._addRefTypeAndRepositoryToResults.call(this, results);

            var uri = nav.parse(window.location.href);

            _lodash2.default.forEach(_lodash2.default.reject(results.values, 'url'), function (ref) {
                var refUri = uri.clone();
                refUri.replaceQueryParam(refQueryParam, ref.id);
                ref.url = refUri.query() + (refUri.anchor() ? refUri.anchor() : '');
            });

            return results;
        };

        var getContextData = function getContextData() {
            var context = {
                container: 'branch-actions-cse-menu',
                repository: _pageState2.default.getRepository().toJSON(),
                atRevisionRef: _pageState2.default.getRevisionRef().toJSON(),
                hasRepoWrite: hasRepoWrite,
                hasRepoFeatureArchive: hasRepoFeatureArchive,
                canCloneRepository: canCloneRepository,
                isRepositoryEmpty: isRepositoryEmpty,
                hasRepoFeatureCompare: hasRepoFeatureCompare
            };

            if (_pageState2.default.getCurrentUser()) {
                context.currentUser = _pageState2.default.getCurrentUser().toJSON();
            }

            return context;
        };

        var revisionReferenceSelector = new _revisionReferenceSelector2.default((0, _jquery2.default)(revisionSelector), {
            id: 'inline-dialog-repository-layout-revision-selector-dialog',
            ariaLabel: _aui.I18n.getText('bitbucket.web.revisionref.selector.source.branch.or.tag.label'),
            dataTransform: addUrlToResults
        });
        shortcuts.bind('branchSelector', _lodash2.default.ary(_jquery2.default.fn.click.bind(revisionReferenceSelector.$trigger), 0));

        _pageState2.default.setRevisionRef(revisionReferenceSelector.getSelectedItem());

        /* Cascade changes upward */
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.repository.revisionReferenceSelector.revisionRefChanged', function (revisionReference) {
            if (this === revisionReferenceSelector) {
                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.layout.branch.revisionRefChanged', this, revisionReference);
                _pageState2.default.setRevisionRef(revisionReferenceSelector.getSelectedItem());

                if (isCSEEnabled) {
                    _events2.default.trigger('bitbucket.internal.DO_NOT_USE.layout.branch.actions.extensionPointContextLoaded', null, getContextData());
                }
            }
        });

        /* React to page changes */
        _events2.default.on('bitbucket.internal.DO_NOT_USE.page.*.revisionRefChanged', function (revisionReference) {
            revisionReferenceSelector.setSelectedItem(new _revisionReference2.default(revisionReference.toJSON()));
        });

        var $actionsTrigger = (0, _jquery2.default)('#branch-actions');
        var $actionsMenu = (0, _jquery2.default)('#branch-actions-menu');

        if (isCSEEnabled) {
            $actionsMenu.html("<ul id='branch-actions-cse-menu'></ul>");

            // Handshake with the web-fragment extension point
            // We are making sure here if any of the file is loaded first, it triggers the contextLoaded event
            // That happens when webpack is loaded and then this file is loaded
            _events2.default.on('bitbucket.internal.DO_NOT_USE.layout.branch.actions.callExtensionPointContextLoaded', function () {
                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.layout.branch.actions.extensionPointContextLoaded', null, getContextData());
            });

            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.layout.branch.actions.extensionPointContextLoaded', null, getContextData());
        }

        $actionsMenu.on('aui-dropdown2-show', function () {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.layout.branch.actions.dropdownShown');
            // Focus dropdown2 trigger because if coming from an open branch-selector, the hidecallback will focus
            // the branch selector trigger, hiding the branch-actions dropdown
            $actionsTrigger.focus();
            // dropdown items are client-web-items
            if (!isCSEEnabled) {
                (0, _jquery2.default)(this).html(bitbucket.internal.layout.branch.branchActionsClientside.actionsDropdownMenu({
                    repository: _pageState2.default.getRepository().toJSON(),
                    atRevisionRef: _pageState2.default.getRevisionRef().toJSON()
                }));
            }
        }).on('aui-dropdown2-hide', function () {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.layout.branch.actions.dropdownHidden');
        });

        _branchLayoutAnalytics2.default.initLayoutAnalytics($actionsMenu);
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});