define('bitbucket/internal/model/commit-range', ['module', 'exports', '@atlassian/backbone-brace', 'bitbucket/internal/enums', 'bitbucket/internal/model/revision'], function (module, exports, _backboneBrace, _enums, _revision) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _backboneBrace2 = _interopRequireDefault(_backboneBrace);

    var _revision2 = _interopRequireDefault(_revision);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var COMMIT = _enums.DiffType.COMMIT,
        RANGE = _enums.DiffType.RANGE;

    var ROOT = 'ROOT';

    /**
     * Generate an ID from the pull request or revisions. Brace complains about
     * defining a getId function, so we eagerly calculate this.
     * Should it cause a performance concern at some point, we should take a look at modifying Brace.
     * It's very unlikely that will happen though.
     */
    function getId(commitRange) {
        //Get a string identifier that can be used as a key in a map of CommitRanges

        return commitRange.getUntilRevision().getId() + '_' + (commitRange.getSinceRevision() ? commitRange.getSinceRevision().getId() : ROOT);
    }

    function getDiffType(commitRange) {
        var sinceId = commitRange.getSinceRevision() ? commitRange.getSinceRevision().getId() : ROOT;

        var untilParent = commitRange.getUntilRevision().hasParents() && commitRange.getUntilRevision().getParents()[0];
        var untilParentId = untilParent ? untilParent.getId() : ROOT;

        return untilParentId === sinceId ? COMMIT : RANGE;
    }

    exports.default = _backboneBrace2.default.Model.extend({
        namedAttributes: {
            diffType: 'string',
            untilRevision: _revision2.default,
            sinceRevision: _revision2.default
        },
        initialize: function initialize() {
            if (!this.getUntilRevision()) {
                throw new Error('Commits range requires revision(s)');
            }

            if (this.getSinceRevision() && this.getSinceRevision().getId() === ROOT) {
                this.setSinceRevision(undefined);
            }

            this.setId(getId(this));

            if (!this.getDiffType()) {
                this.setDiffType(getDiffType(this));
            }
        }
    });
    module.exports = exports['default'];
});