define('bitbucket/internal/model/file-change', ['module', 'exports', '@atlassian/backbone-brace', 'bitbucket/internal/enums', 'bitbucket/internal/model/commit-range', 'bitbucket/internal/model/path', 'bitbucket/internal/model/repository'], function (module, exports, _backboneBrace, _enums, _commitRange, _path, _repository) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _backboneBrace2 = _interopRequireDefault(_backboneBrace);

    var _commitRange2 = _interopRequireDefault(_commitRange);

    var _path2 = _interopRequireDefault(_path);

    var _repository2 = _interopRequireDefault(_repository);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var FileChange = _backboneBrace2.default.Model.extend({
        namedAttributes: {
            repository: _repository2.default,
            commitRange: _commitRange2.default,
            srcPath: _path2.default,
            path: _path2.default,
            line: null,
            search: null,
            type: null,
            nodeType: null,
            diff: null,
            srcExecutable: null,
            executable: null
        },
        initialize: function initialize() {
            this.setType(FileChange._mapChangeType(this.getType(), this.getSrcPath(), this.getPath()));
        }
    }, {
        _mapChangeType: function _mapChangeType(modState, srcPath, path) {
            return modState === _enums.ChangeTypes.MOVE && srcPath && srcPath.isSameDirectory(path) ? _enums.ChangeTypes.RENAME : modState;
        }
    });

    exports.default = FileChange;
    module.exports = exports['default'];
});