define('bitbucket/internal/page/admin/groups/groupedit', ['module', 'exports', '@atlassian/aui', 'jquery', 'bitbucket/internal/feature/user/group-users-table/group-users-table', 'bitbucket/internal/util/notifications/notifications', 'bitbucket/internal/widget/delete-dialog/delete-dialog', 'bitbucket/util/navbuilder'], function (module, exports, _aui, _jquery, _groupUsersTable, _notifications, _deleteDialog, _navbuilder) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _groupUsersTable2 = _interopRequireDefault(_groupUsersTable);

    var notifications = _interopRequireWildcard(_notifications);

    var _deleteDialog2 = _interopRequireDefault(_deleteDialog);

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function onReady(readOnly, groupUsersTableSelector, deleteLinkSelector) {
        // dialog to confirm the deletion of the group
        _deleteDialog2.default.bind(deleteLinkSelector, AJS.I18n.getText('bitbucket.web.group.delete'), AJS.I18n.getText('bitbucket.web.group.delete.success'), AJS.I18n.getText('bitbucket.web.group.delete.fail'), function (name) {
            notifications.addFlash(AJS.I18n.getText('bitbucket.web.group.delete.success', name));
            window.location = nav.admin().groups().build();

            return false; // don't notify on view page, wait for page-pop
        }, function () {
            return (0, _jquery2.default)('#group-name').text();
        });

        // list of users in the group
        var usersTable = new _groupUsersTable2.default({
            target: groupUsersTableSelector
        });
        usersTable.init();
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});