define('bitbucket/internal/page/admin/groups/grouplist', ['module', 'exports', '@atlassian/aui', 'bitbucket/internal/feature/user/group-table/group-table', 'bitbucket/internal/util/notifications/notifications', 'bitbucket/internal/widget/delete-dialog/delete-dialog'], function (module, exports, _aui, _groupTable, _notifications, _deleteDialog) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _groupTable2 = _interopRequireDefault(_groupTable);

    var notifications = _interopRequireWildcard(_notifications);

    var _deleteDialog2 = _interopRequireDefault(_deleteDialog);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function onReady(tableSelector, deleteLinksSelector) {
        notifications.showFlashes();

        var groupTable = new _groupTable2.default({
            target: tableSelector
        });

        groupTable.init();

        // confirm dialog to delete groups
        _deleteDialog2.default.bind(deleteLinksSelector, AJS.I18n.getText('bitbucket.web.group.delete'), AJS.I18n.getText('bitbucket.web.group.delete.success'), AJS.I18n.getText('bitbucket.web.group.delete.fail'), function (group) {
            notifications.addFlash(AJS.I18n.getText('bitbucket.web.group.delete.success', group));
            location.reload();
        });
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});