define('bitbucket/internal/page/commits/commits', ['module', 'exports', '@bitbucket/commit/commit-details/commit-signature/soy-binder', 'jquery', 'react', 'react-dom', 'bitbucket/internal/feature/commits/commits-table', 'bitbucket/internal/model/revision-reference', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/events', 'bitbucket/internal/util/history', 'bitbucket/util/navbuilder', 'bitbucket/util/state', './commits-page-graph'], function (module, exports, _soyBinder, _jquery, _react, _reactDom, _commitsTable, _revisionReference, _analytics, _events, _history, _navbuilder, _state, _commitsPageGraph) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _soyBinder2 = _interopRequireDefault(_soyBinder);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    var _commitsTable2 = _interopRequireDefault(_commitsTable);

    var _revisionReference2 = _interopRequireDefault(_revisionReference);

    var analytics = _interopRequireWildcard(_analytics);

    var _events2 = _interopRequireDefault(_events);

    var _history2 = _interopRequireDefault(_history);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    // eslint-disable-next-line import/no-unresolved
    var atRevisionRef = void 0;
    var commitsTable = void 0;
    var merges = void 0;
    var pageReadyTime = void 0;

    /**
     * @enum String
     */
    var MergesFilter = Object.freeze({
        INCLUDE: 'include',
        EXCLUDE: 'exclude'
    });

    function getCommitsUrlBuilder(atRevRef) {
        var builder = nav.repository(_state2.default.getRepository()).commits();

        atRevRef = atRevRef || atRevisionRef;
        if (!atRevRef.isDefault()) {
            builder = builder.withParams({ until: atRevRef.getId() });
        }

        if (merges) {
            builder = builder.withParams({ merges: merges });
        }

        return builder;
    }

    function bindKeyboardShortcuts() {
        commitsTable.bindKeyboardShortcuts();

        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.keyboard-shortcuts.register-contexts', function (keyboardShortcuts) {
            keyboardShortcuts.enableContext('commits');
        });

        var disableOpenHandler = function disableOpenHandler() {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.disableOpenItemHandler');
        };

        var enableOpenHandler = function enableOpenHandler() {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.enableOpenItemHandler');
        };
        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.branchselector.dialogShown', disableOpenHandler);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.branchselector.dialogHidden', enableOpenHandler);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.layout.branch.actions.dropdownShown', disableOpenHandler);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.layout.branch.actions.dropdownHidden', enableOpenHandler);
    }

    var navigateToCommit = function navigateToCommit(commitId) {
        return location.href = nav.repository(_state2.default.getRepository()).commit(commitId).build();
    };

    var graphNodeClick = function graphNodeClick(commitId) {
        analytics.add('commitgraph.commit.clicked', {
            'repository.id': _state2.default.getRepository().id,
            'time.to.click': Date.now() - pageReadyTime
        });
        navigateToCommit(commitId);
    };

    function onReady(atRevisionRefJSON, mergeFilter, _ref) {
        var commitGraphEl = _ref.commitGraphEl;

        pageReadyTime = Date.now();
        atRevisionRef = new _revisionReference2.default(atRevisionRefJSON);
        merges = mergeFilter;
        commitsTable = new _commitsTable2.default(getCommitsUrlBuilder, { focusFirstRow: true });

        if (commitGraphEl) {
            _reactDom2.default.render(_react2.default.createElement(_commitsPageGraph.CommitsPageGraph, {
                headerRowHeight: commitsTable.$table.find('> thead > tr:first').outerHeight(),
                rowHeight: commitsTable.$table.find('> tbody > tr:last').outerHeight(),
                onNodeClick: graphNodeClick
            }), commitGraphEl);
        }

        // bind merges filter
        (0, _jquery2.default)('#show-merges-checkbox').on('click', function (e) {
            if (e.target.checked) {
                merges = MergesFilter.INCLUDE;
            } else {
                merges = MergesFilter.EXCLUDE;
            }
            analytics.add('commit.filters.show.merges', {
                'repository.id': _state2.default.getRepository().id,
                'time.to.click': Date.now() - pageReadyTime,
                'hide.merge.commits': e.target.checked
            });
            _history2.default.pushState(atRevisionRef.toJSON(), null, getCommitsUrlBuilder().build());
        });

        //Needs to be after the CommitsPageGraph to allow it to set up event listeners
        commitsTable.init();

        (0, _jquery2.default)('#commits-table').on('click', 'a.commitid', function () {
            analytics.add('stash.client.commitstable.commit.clicked', {
                'repository.id': _state2.default.getRepository().id,
                'time.to.click': Date.now() - pageReadyTime
            });
        });

        (0, _jquery2.default)('#commits-table').on('click', '.commit-signature-dialog-button', function () {
            _soyBinder2.default.render(this);
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.layout.branch.revisionRefChanged', function (newAtRevisionRef) {
            if (atRevisionRef.getId() !== newAtRevisionRef.getId()) {
                _history2.default.pushState(newAtRevisionRef.toJSON(), null, getCommitsUrlBuilder(newAtRevisionRef).build());
            }
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.history.changestate', function (e) {
            var state = e.state;

            if (state) {
                //Reset page ready time to be from the start of switch branches instead of page load
                pageReadyTime = Date.now();
                atRevisionRef = new _revisionReference2.default(state);
                commitsTable.update();
                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.page.commits.revisionRefChanged', null, atRevisionRef);
            }
        });

        bindKeyboardShortcuts();

        _history2.default.initialState(atRevisionRef.toJSON());
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});