define('bitbucket/internal/page/filebrowser/filebrowser', ['module', 'exports', '@atlassian/aui', 'chaperone', 'jquery', 'lodash', 'bitbucket/internal/enums', 'bitbucket/internal/feature/filebrowser/file-finder/file-finder', 'bitbucket/internal/feature/filebrowser/file-table/file-table', 'bitbucket/internal/model/path', 'bitbucket/internal/model/revision-reference', 'bitbucket/internal/util/events'], function (module, exports, _aui, _chaperone, _jquery, _lodash, _enums, _fileFinder, _fileTable, _path, _revisionReference, _events) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _chaperone2 = _interopRequireDefault(_chaperone);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _fileFinder2 = _interopRequireDefault(_fileFinder);

    var _fileTable2 = _interopRequireDefault(_fileTable);

    var _path2 = _interopRequireDefault(_path);

    var _revisionReference2 = _interopRequireDefault(_revisionReference);

    var _events2 = _interopRequireDefault(_events);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var FileTable = _fileTable2.default.FileTable;
    var FileTableView = _fileTable2.default.FileTableView;
    var FileFinder = _fileFinder2.default.FileFinder;
    var dialogIsShowing;

    var fileTable;
    var fileTableView;
    var fileFinder;

    var findFilesTooltip;
    var browseFilesTooltip;
    var $findFilesItem;
    var $content;
    var $findFilesButton;
    var $browseFilesButton;

    function getFileNamesFromDOM() {
        return $content.find('.file-row a').map(function (i, row) {
            var $row = (0, _jquery2.default)(row);
            var $parent = $row.parent().parent();

            return {
                name: $row.text(),
                contentId: $row.attr('data-contentId'),
                type: $parent.hasClass('file') ? _enums.ContentNodeType.FILE : $parent.hasClass('directory') ? _enums.ContentNodeType.DIRECTORY : _enums.ContentNodeType.SUBMODULE
            };
        }).toArray();
    }

    function onReady(path, revisionRef, fileTableWrapper, fileTableContainer, maxDirectoryChildren) {
        var currentPath = new _path2.default(path);
        var currentRevisionRef = new _revisionReference2.default(revisionRef);

        $findFilesItem = (0, _jquery2.default)('.find-files');
        $content = (0, _jquery2.default)('.filebrowser-content');
        $findFilesButton = $findFilesItem.find('.find-files-button');
        $browseFilesButton = $findFilesItem.find('.browse-files-button');

        fileTableView = new FileTableView(fileTableWrapper);

        fileTable = new FileTable(currentPath, currentRevisionRef, maxDirectoryChildren);

        fileFinder = new FileFinder(fileTableContainer, currentRevisionRef);

        (0, _jquery2.default)(document).on('focus', '#browse-table tr.file-row', function () {
            (0, _jquery2.default)('.focused-file').removeClass('focused-file');
            (0, _jquery2.default)(this).addClass('focused-file');
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.history.popstate', function (e) {
            if (e.state) {
                currentRevisionRef = new _revisionReference2.default(e.state.revisionRef);
            } // else ignore hashchange events
        });

        var pipeRevisionChanged = function pipeRevisionChanged(revisionReference) {
            if (currentRevisionRef !== revisionReference) {
                currentRevisionRef = revisionReference;
                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.page.filebrowser.revisionRefChanged', null, revisionReference);
            }
        };
        _events2.default.on('bitbucket.internal.DO_NOT_USE.layout.branch.revisionRefChanged', pipeRevisionChanged);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.filetable.revisionRefChanged', pipeRevisionChanged);

        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.branchselector.dialogShown', function () {
            dialogIsShowing = true;
        });
        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.branchselector.dialogHidden', function () {
            dialogIsShowing = false;
        });

        var pipeUrlChanged = function pipeUrlChanged(url) {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.page.filebrowser.urlChanged', null, url);
        };
        _events2.default.on('bitbucket.internal.DO_NOT_USE.layout.*.urlChanged', pipeUrlChanged);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.*.urlChanged', pipeUrlChanged);

        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.*.pathChanged', function (path) {
            currentPath = new _path2.default(path);
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.page.filebrowser.pathChanged', null, currentPath.toJSON());
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.keyboard-shortcuts.register-contexts', function (keyboardShortcuts) {
            keyboardShortcuts.enableContext('filebrowser');
        });

        var showFinder = function showFinder() {
            if (!fileFinder.isLoaded()) {
                $findFilesButton.attr('aria-pressed', true);
                $browseFilesButton.attr('aria-pressed', false);

                fileFinder.loadFinder();
            }
        };

        var hideFinder = function hideFinder() {
            if (fileFinder.isLoaded()) {
                $findFilesButton.attr('aria-pressed', false);
                $browseFilesButton.attr('aria-pressed', true);

                fileFinder.unloadFinder();

                if (fileTable.data) {
                    fileTableView.update(fileTable.data);
                } else {
                    fileTable.reload();
                }
            }
        };

        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.filetable.showFind', showFinder);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.filetable.hideFind', hideFinder);
        //If the revision has changed, close the file finder and show the browse file link
        _events2.default.on('bitbucket.internal.DO_NOT_USE.page.filebrowser.revisionRefChanged', hideFinder);

        /**
         * Notify listeners of the initial files and when there are subsequent changes.
         */
        _events2.default.trigger('bitbucket.internal.DO_NOT_USE.feature.filebrowser.filesChanged', null, {
            files: getFileNamesFromDOM(),
            path: new _path2.default(path).toJSON(),
            revision: currentRevisionRef.getId()
        });
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.filetable.dataReceived', function (data) {
            if (isDataReceivedErrorResponse(data)) {
                return;
            }
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.feature.filebrowser.filesChanged', null, {
                files: data.children.values.map(function (child) {
                    return _lodash2.default.pick(child, 'name', 'contentId', 'type');
                }),
                path: data.path,
                revision: data.revisionRef && data.revisionRef.id
            });
        });

        $findFilesButton.click(function () {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.feature.filetable.showFind');

            return false;
        });

        $browseFilesButton.click(function () {
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.feature.filetable.hideFind');

            return false;
        });

        listenForKeyboardShortcutRequests();

        _chaperone2.default.registerFeature('watch-repository', [{
            id: 'watch-repository',
            alignment: 'top right',
            selector: '.watch-repository-feature-discovery-trigger',
            title: AJS.I18n.getText('bitbucket.web.repository.watch.discovery.title'),
            content: bitbucket.internal.widget.paragraph.paragraph({
                text: AJS.I18n.getText('bitbucket.web.repository.watch.discovery.desc')
            }),
            close: {
                text: AJS.I18n.getText('bitbucket.web.got.it')
            },
            width: 350,
            once: true
        }]);
    }

    /**
     * Indicate whether the data object from a dataReceived event is an error response
     *
     * @param {object} [data]
     * @returns {boolean}
     */
    function isDataReceivedErrorResponse(data) {
        return !(data && data.children);
    }

    function listenForKeyboardShortcutRequests() {
        var options = {
            focusedClass: 'focused-file',
            wrapAround: false,
            escToCancel: false
        };
        var rowSelector = '#browse-table tr.file-row';
        var focusedRowSelector = rowSelector + '.' + options.focusedClass;

        _events2.default.on('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.requestMoveToNextHandler', function (keys) {
            (this.moveToNextItem ? this : AJS.whenIType(keys)).moveToNextItem(rowSelector, options);
        });
        _events2.default.on('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.requestMoveToPreviousHandler', function (keys) {
            (this.moveToPrevItem ? this : AJS.whenIType(keys)).moveToPrevItem(rowSelector, options);
        });
        _events2.default.on('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.requestOpenItemHandler', function (keys) {
            (this.execute ? this : AJS.whenIType(keys)).execute(function () {
                if (!dialogIsShowing) {
                    var $focusItem = (0, _jquery2.default)(focusedRowSelector);

                    if ($focusItem.length) {
                        if ($focusItem.hasClass('file')) {
                            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.feature.filetable.showSpinner', this);
                            window.location.href = $focusItem.find('a').attr('href');
                        } else {
                            $focusItem.find('a').click();
                        }
                    }
                }
            });
        });
        _events2.default.on('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.requestOpenParentHandler', function (keys) {
            (this.execute ? this : AJS.whenIType(keys)).execute(function () {
                if (!dialogIsShowing) {
                    var $parentDir = (0, _jquery2.default)(fileTableView.getParentDirSelector());

                    if ($parentDir.length) {
                        $parentDir.click();
                    }
                }
            });
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.requestOpenFileFinderHandler', function (keys) {
            findFilesTooltip = AJS.I18n.getText('bitbucket.web.file.finder.findfiles.tooltip', keys);
            $findFilesButton.attr('title', findFilesTooltip).tooltip({
                gravity: 'ne'
            });

            (this.execute ? this : AJS.whenIType(keys)).execute(function () {
                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.feature.filetable.showFind', this);
            });
        });
        _events2.default.on('bitbucket.internal.DO_NOT_USE.keyboard.shortcuts.requestCloseFileFinderHandler', function (keys) {
            browseFilesTooltip = AJS.I18n.getText('bitbucket.web.file.finder.browse.files.tooltip', keys);
            $browseFilesButton.attr('title', browseFilesTooltip).tooltip();

            (this.execute ? this : AJS.whenIType(keys)).execute(function () {
                if ($browseFilesButton.attr('aria-pressed') === 'true') {
                    return;
                }

                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.feature.filetable.hideFind', this);
            });
        });
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});