define('bitbucket/internal/page/maintenance/migration/migration', ['module', 'exports', '@atlassian/aui', 'bitbucket/internal/layout/maintenance/maintenance', 'bitbucket/util/navbuilder'], function (module, exports, _aui, _maintenance, _navbuilder) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _maintenance2 = _interopRequireDefault(_maintenance);

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function onReady(hasToken) {
        var opts = {
            redirectUrl: hasToken ? nav.admin().db().build() : nav.dashboard().build(),
            canceledHeader: AJS.I18n.getText('bitbucket.web.migration.canceled.title'),
            cancelingDescription: AJS.I18n.getText('bitbucket.web.migration.canceling.description'),
            cancelDialogTitle: AJS.I18n.getText('bitbucket.web.migration.dialog.title'),
            cancelDialogDescription: AJS.I18n.getText('bitbucket.web.migration.dialog.description', bitbucket.internal.util.productInfo.productInfo.productName()),
            cancelDialogButtonText: AJS.I18n.getText('bitbucket.web.migration.dialog.cancel')
        };

        _maintenance2.default.init(opts);
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});