define('bitbucket/internal/page/project-create/project-create', ['module', 'exports', 'jquery', 'bitbucket/internal/feature/project/project-avatar-picker/project-avatar-picker', 'bitbucket/util/events'], function (module, exports, _jquery, _projectAvatarPicker, _events) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _projectAvatarPicker2 = _interopRequireDefault(_projectAvatarPicker);

    var _events2 = _interopRequireDefault(_events);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function onReady() {
        (0, _jquery2.default)('#key').generateFrom((0, _jquery2.default)('#name'), {
            maxNameLength: 128,
            maxKeyLength: 128
        });

        var xsrfToken = {
            name: 'atl_token',
            value: (0, _jquery2.default)('.project-create input[name=atl_token]').val()
        };

        new _projectAvatarPicker2.default('.avatar-picker-field', {
            xsrfToken: xsrfToken
        });

        (0, _jquery2.default)('#avatar-picker-button').on('click', _events2.default.trigger.bind(null, 'bitbucket.internal.DO_NOT_USE.ui.project-create.change-avatar.clicked'));
        (0, _jquery2.default)('form.project-settings').on('submit', function (e) {
            var descriptionLength = (0, _jquery2.default)('#description').val().length;
            var avatarChanged = (0, _jquery2.default)('#avatar').val().length > 0;
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.ui.project-create.submitted', null, {
                descriptionLength: descriptionLength,
                avatarChanged: avatarChanged
            });
        });
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});