define('bitbucket/internal/page/project/permissions/project-permissions-model', ['module', 'exports', '@atlassian/backbone-brace', 'lodash', 'bitbucket/internal/util/ajax', 'bitbucket/util/navbuilder', 'bitbucket/util/state'], function (module, exports, _backboneBrace, _lodash, _ajax, _navbuilder, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _backboneBrace2 = _interopRequireDefault(_backboneBrace);

    var _lodash2 = _interopRequireDefault(_lodash);

    var ajax = _interopRequireWildcard(_ajax);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var ProjectPermissionsModel = _backboneBrace2.default.Model.extend({
        namedAttributes: {
            grantedDefaultPermission: 'string',
            publicAccess: 'boolean'
        },

        getEffectiveDefaultPermission: function getEffectiveDefaultPermission() {
            return this.getPublicAccess() && this.getGrantedDefaultPermission() === ProjectPermissionsModel.NONE ? ProjectPermissionsModel.READ : this.getGrantedDefaultPermission();
        },

        savePublicAccess: function savePublicAccess(allow) {
            var previouslyAllowed = this.getPublicAccess();
            this.setPublicAccess(allow);

            return ProjectPermissionsModel._sendSavePublicAccessRequest(allow).fail(_lodash2.default.bind(function () {
                // Revert on failure
                this.setPublicAccess(previouslyAllowed);
            }, this));
        },

        /**
         * Given a single permission level (REPO_CREATE, WRITE or READ) this function will send 3 API calls
         * indicating whether create repository, write or read is allowed
         */
        saveDefaultPermission: function saveDefaultPermission(permission) {
            var perms = ProjectPermissionsModel.unpackPermission(permission);
            var model = this;
            var previousPermission = this.getGrantedDefaultPermission();

            this.setGrantedDefaultPermission(permission);

            // Attempt to save read permission
            return ProjectPermissionsModel._sendSavePermissionRequest(permsNavBuilder().projectRead().all(), perms.read).then(function () {
                // Saving read permission succeeded, attempt to save write permission
                return ProjectPermissionsModel._sendSavePermissionRequest(permsNavBuilder().projectWrite().all(), perms.write).then(function () {
                    // Saving write permission succeeded, attempt to save create repository permission
                    return ProjectPermissionsModel._sendSavePermissionRequest(permsNavBuilder().repoCreate().all(), perms.repo_create).fail(function () {
                        // Saving write permission succeeded, but create repository failed - revert the create repository part
                        var repoCreatePreviouslyAllowed = ProjectPermissionsModel.unpackPermission(previousPermission).repo_create;
                        perms.repo_create = repoCreatePreviouslyAllowed;
                        model.setGrantedDefaultPermission(ProjectPermissionsModel.packPermission(perms));
                    });
                }).fail(function () {
                    // Saving read permission succeeded, but write failed - revert the write part
                    var writePreviouslyAllowed = ProjectPermissionsModel.unpackPermission(previousPermission).write;
                    perms.write = writePreviouslyAllowed;
                    model.setGrantedDefaultPermission(ProjectPermissionsModel.packPermission(perms));
                });
            }, function () {
                // Saving read permission failed
                model.setGrantedDefaultPermission(previousPermission);
            });
        }
    }, {
        REPO_CREATE: 'repo_create',
        WRITE: 'write',
        READ: 'read',
        NONE: 'none',

        /**
         * Given a single permission level (REPO_CREATE, WRITE, READ or NONE) returns individual boolean values for
         * whether create repository, write or read is allowed.
         */
        unpackPermission: function unpackPermission(permission) {
            return {
                read: permission === ProjectPermissionsModel.REPO_CREATE || permission === ProjectPermissionsModel.WRITE || permission === ProjectPermissionsModel.READ,
                write: permission === ProjectPermissionsModel.REPO_CREATE || permission === ProjectPermissionsModel.WRITE,
                repo_create: permission === ProjectPermissionsModel.REPO_CREATE
            };
        },

        /**
         * Given individual boolean values for whether create repository, write or read is allowed, returns the corresponding
         * permission level (REPO_CREATE, WRITE, READ or NONE).
         */
        packPermission: function packPermission(permissions) {
            return permissions.repo_create ? ProjectPermissionsModel.REPO_CREATE : permissions.write ? ProjectPermissionsModel.WRITE : permissions.read ? ProjectPermissionsModel.READ : ProjectPermissionsModel.NONE;
        },

        _sendSavePermissionRequest: function _sendSavePermissionRequest(permsNavBuilder, allow) {
            return ajax.rest({
                type: 'POST',
                url: permsNavBuilder.allow(allow).build()
            });
        },

        _sendSavePublicAccessRequest: function _sendSavePublicAccessRequest(allow) {
            return ajax.rest({
                type: 'PUT',
                url: nav.rest().project(_state2.default.getProject()).build(),
                data: {
                    public: allow
                }
            });
        }
    });

    function permsNavBuilder() {
        return nav.rest().project(_state2.default.getProject()).permissions();
    }

    exports.default = ProjectPermissionsModel;
    module.exports = exports['default'];
});