define('bitbucket/internal/page/project/settings/general/project-settings', ['module', 'exports', '@atlassian/aui', 'jquery', 'bitbucket/internal/feature/project/project-avatar-picker/project-avatar-picker', 'bitbucket/internal/model/page-state', 'bitbucket/internal/util/ajax', 'bitbucket/internal/util/notifications/notifications', 'bitbucket/internal/widget/confirm-dialog/confirm-dialog', 'bitbucket/util/navbuilder', 'bitbucket/util/state'], function (module, exports, _aui, _jquery, _projectAvatarPicker, _pageState, _ajax, _notifications, _confirmDialog, _navbuilder, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _projectAvatarPicker2 = _interopRequireDefault(_projectAvatarPicker);

    var _pageState2 = _interopRequireDefault(_pageState);

    var ajax = _interopRequireWildcard(_ajax);

    var notifications = _interopRequireWildcard(_notifications);

    var _confirmDialog2 = _interopRequireDefault(_confirmDialog);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function initDeleteButton(deleteButtonSelector) {
        var $panelContent;
        var $spinner;

        var confirmDialog = new _confirmDialog2.default({
            id: 'delete-project-dialog',
            titleText: AJS.I18n.getText('bitbucket.web.project.delete.dialog.title'),
            titleClass: 'warning-header',
            confirmButtonClass: 'delete-confirm-button',
            panelContent: '<div class="container"></div>', // css class used for func test
            submitText: AJS.I18n.getText('bitbucket.web.button.delete'),
            focusSelector: '.cancel-button',
            destructiveAction: true
        }, { type: 'DELETE' });

        function initContent() {
            $panelContent.empty();
            $spinner = (0, _jquery2.default)("<div class='spinner'></div>").appendTo($panelContent);
        }

        function setDeleteButtonDisabled(disabled) {
            confirmDialog.setConfirmButtonDisabled(disabled);
        }

        function okToDeleteProject() {
            $panelContent.append(bitbucket.internal.page.project.settings.general.projectSettings.deleteDialog({
                project: _pageState2.default.getProject().toJSON()
            }));

            var projectName = _pageState2.default.getProject().getName();
            var $input = $panelContent.find('#confirmProjectName');

            if ($input.val() !== projectName) {
                setDeleteButtonDisabled(true);
            }

            $input.on('input', function () {
                return setDeleteButtonDisabled($input.val() !== projectName);
            });
            (0, _jquery2.default)('#delete-project-dialog').on('submit', function (e) {
                return e.preventDefault();
            });
        }

        function cannotDeleteProject() {
            $panelContent.append(bitbucket.internal.page.project.settings.general.projectSettings.deleteDisabledDialog({
                project: _pageState2.default.getProject().toJSON()
            }));
            setDeleteButtonDisabled(true);
        }

        $panelContent = (0, _jquery2.default)(confirmDialog.getContentElement()).find('.container');
        confirmDialog.attachTo(deleteButtonSelector, function () {
            $panelContent = (0, _jquery2.default)(confirmDialog.getContentElement()).find('.container');
            initContent();
            setDeleteButtonDisabled(true);
            $spinner.spin('large');
            ajax.rest({
                url: nav.rest().project(_state2.default.getProject()).allRepos().build(),
                statusCode: {
                    '*': false // don't show any error messages.
                }
            }).done(function (data) {
                if (data && data.size) {
                    cannotDeleteProject();
                } else {
                    okToDeleteProject();
                }
            }).fail(function () {
                okToDeleteProject();
            }).always(function () {
                $spinner.spinStop().remove();
            });
        });

        confirmDialog.addConfirmListener(function (promise) {
            promise.done(function (data) {
                notifications.addFlash(null, {
                    body: AJS.I18n.getText('bitbucket.web.project.deleted', AJS.escapeHtml(_pageState2.default.getProject().getName()))
                });

                window.location = nav.allProjects().build();
            });
        });
    }

    function onReady() {
        var xsrfToken = {
            name: 'atl_token',
            value: (0, _jquery2.default)('.project-settings input[name=atl_token]').val()
        };

        new _projectAvatarPicker2.default('.avatar-picker-field', {
            xsrfToken: xsrfToken
        });
    }

    exports.default = {
        initDeleteButton: initDeleteButton,
        onReady: onReady
    };
    module.exports = exports['default'];
});